% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPCEInflation.R
\name{getPCEInflation}
\alias{getPCEInflation}
\title{Load and Process Personal Consumption Expenditures (PCE) Data}
\usage{
getPCEInflation(frequency = "M", NIPA_data = NULL)
}
\arguments{
\item{frequency}{Character string indicating the frequency of the data.
Defaults to \code{"M"} (monthly).}

\item{NIPA_data}{Optional data frame. If provided, it will be used as the raw NIPA dataset
instead of loading fresh data with \code{getNIPAFiles()}.'}
}
\value{
A \code{tbl_df} (data frame) containing the PCE data with calculated variables.
}
\description{
This function loads flat files containing various economic data at the specified frequency
and processes them to compute the Personal Consumption Expenditures (PCE) series.
}
\details{
It performs the following steps:
\enumerate{
\item Loads the full dataset using \code{load_flat_files}.
\item Extracts total GDP data (from table \code{"U20405"} and series code \code{"DPCERC"}).
\item Computes the PCE weight for each observation as the nominal consumption share
(i.e., consumption value divided by total GDP).
\item Extracts a quantity measure from table \code{"U20403"}.
\item Loads the PCE data from table \code{"U20404"}, joins the computed weights and quantity data,
and calculates several period-over-period growth measures.
}
}
\examples{
\donttest{
  # Load monthly PCE data
  pce_data <- getPCEInflation("M")
}

}
