% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_samplers.R
\name{construct_samplers}
\alias{construct_samplers}
\title{Construct a list of samplers for synthesis}
\usage{
construct_samplers(
  roadmap,
  default_regression_sampler = NULL,
  default_classification_sampler = NULL,
  custom_samplers = NULL
)
}
\arguments{
\item{roadmap}{A roadmap object}

\item{default_regression_sampler}{A sampler function for regression models}

\item{default_classification_sampler}{A sampler function for classification models}

\item{custom_samplers}{A formatted list of sampler functions}
}
\value{
A named list of samplers
}
\description{
Construct a list of samplers for synthesis
}
\examples{

# construct_samplers() can create a sequence of samplers using a fully-default 
# approach, a hybrid approach, or a fully-customized approach. All approaches
# require a roadmap and samplers. 

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

# Fully-default approach

construct_samplers(
  roadmap = rm, 
  default_regression_sampler = sample_lm, 
  default_classification_sampler = sample_rpart
)

# Hybrid approach

construct_samplers(
  roadmap = rm, 
  default_regression_sampler = sample_lm,
  default_classification_sampler = sample_rpart,
  custom_samplers = list(
    list(vars = "hcovany", sampler = sample_rpart)
  )
)

# Fully-customized approach

construct_samplers(
  roadmap = rm, 
  custom_samplers = list(
    list(vars = c("hcovany", "empstat", "classwkr"), sampler = sample_rpart),
    list(vars = c("age", "famsize", "transit_time", "inctot"), sampler = sample_lm)
  )
)

}
