% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pca_tidiers.R
\name{augment_loci_gt_pca}
\alias{augment_loci_gt_pca}
\alias{augment_loci.gt_pca}
\title{Augment the loci table with information from a gt_pca object}
\usage{
\method{augment_loci}{gt_pca}(x, data = NULL, k = NULL, ...)
}
\arguments{
\item{x}{A \code{gt_pca} object returned by one of the \verb{gt_pca_*} functions.}

\item{data}{the \code{gen_tibble} used to run the PCA.}

\item{k}{the number of components to add}

\item{...}{Not used. Needed to match generic signature only.}
}
\value{
A \link{gen_tibble} with a loadings added to the loci tibble (accessible
with \code{\link[=show_loci]{show_loci()}}. If \code{data} is missing, a tibble of loadings.
}
\description{
Augment for \code{gt_pca} accepts a model object and a \code{gen_tibble} and adds
loadings for each locus to the loci table. Loadings for each component are
stored in a separate column, which is given name with the pattern
".loadingPC1", ".loadingPC2", etc. If \code{data} is missing, then a tibble with
the loadings is returned.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA
pca <- gt_pca_partialSVD(lobsters)

# Augment the gen_tibble with the PCA scores
augment_loci(pca, data = lobsters)

}
\seealso{
\code{\link[=gt_pca_autoSVD]{gt_pca_autoSVD()}} \link{gt_pca_tidiers}
}
