% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out_popart.R
\name{out_popart}
\alias{out_popart}
\title{Format MSA and traits for PopArt}
\usage{
out_popart(
  msa,
  x,
  blocks = c("DATA", "TRAITS"),
  sname,
  xgroups,
  outnex = tempfile(fileext = ".nex")
)
}
\arguments{
\item{msa}{Multiple sequence alignment as \code{DNAStringSet} or \code{DNAMultipleAlignment}.}

\item{x}{Dataframe with trait data.}

\item{blocks}{NEXUS blocks to add to file. Either \code{"DATA"}, \code{"TRAITS"}
or \code{c("DATA", "TRAITS")}.}

\item{sname}{Column name in 'x' with sequence names which must be
identical to sequence names in \code{msa}.}

\item{xgroups}{Column name in \code{x} used for creating groups in TRAITS.}

\item{outnex}{Path to write NEXUS file.}
}
\value{
No return value. Called for its side effect of writing a NEXUS file to
\code{outnex}. Invisibly returns \code{NULL}.
}
\description{
It takes a multiple sequence alignment and data to create a NEXUS file
which can be read by PopART (https://popart.maths.otago.ac.nz).
}
\examples{
data("genotypes")
x <-
    dplyr::filter(genotypes, locus == "abcg8")
nr <- seq_len(nrow(x))
y <-
    dplyr::mutate(x, sname = paste0("seq_", nr))
msa <-
    tidy2sequences(y, fasta_header = "{sname}") |>
    DECIPHER::AlignSeqs()
out_popart(msa, y,
    sname = "sname",
    xgroups = "sample",
    blocks = c("DATA", "TRAITS")
)
}
