% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_blank}
\alias{theme_blank}
\title{Blank theme}
\usage{
theme_blank(
  add_coord = TRUE,
  xlen_npc = 0.15,
  ylen_npc = 0.15,
  xlab = "",
  ylab = "",
  lab_size = 12,
  ...
)
}
\arguments{
\item{add_coord}{Whether to add coordinate arrows. Default is \code{TRUE}.}

\item{xlen_npc}{The length of the x-axis arrow in "npc".}

\item{ylen_npc}{The length of the y-axis arrow in "npc".}

\item{xlab}{The label of the x-axis.}

\item{ylab}{The label of the y-axis.}

\item{lab_size}{The size of the axis labels.}

\item{...}{Arguments passed to the \link[ggplot2:theme]{ggplot2::theme}.}
}
\value{
A list containing ggplot2 theme objects and annotation objects.
If \code{add_coord} is \code{TRUE}, returns a list with coordinate arrows;
otherwise returns a list with theme only.
}
\description{
This function creates a theme with all elements blank except for axis lines and labels.
It can optionally add coordinate axes in the plot.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(x = wt, y = mpg, colour = factor(cyl))) +
  geom_point()
p + theme_blank()
p + theme_blank(xlab = "x-axis", ylab = "y-axis", lab_size = 16)
}
