% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{adjcolors}
\alias{adjcolors}
\title{Convert a color with specified alpha level}
\usage{
adjcolors(colors, alpha)
}
\arguments{
\item{colors}{Color vectors.}

\item{alpha}{Alpha level in \verb{[0,1]}.}
}
\value{
A character vector of hexadecimal color codes with the specified alpha level.
}
\description{
Convert a color with specified alpha level
}
\examples{
colors <- c("red", "blue", "green")
adjcolors(colors, 0.5)
ggplot2::alpha(colors, 0.5)

show_palettes(
  list(
    "raw" = colors,
    "adjcolors" = adjcolors(colors, 0.5),
    "ggplot2::alpha" = ggplot2::alpha(colors, 0.5)
  )
)
}
