% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{uc}
\alias{uc}
\title{Unobservable components}
\usage{
uc(
  type,
  s2 = NULL,
  s = 12,
  form = c("trig", "dummy"),
  per = 5,
  phi = 0.9,
  counter = 1
)
}
\arguments{
\item{type}{character. The type of component: trend, seasonal, cycle, AR or
irregular.}

\item{s2}{vector with the variances of the errors driving the UC.}

\item{s}{integer. Seasonal period for seasonal components.}

\item{form}{character. The form of the seasonal component (trigonometric or
dummy seasonality).}

\item{per}{numeric. The period of the cycle component.}

\item{phi}{numeric. The damping factor of the cycle component.}

\item{counter}{integer. Counter for numbering phi cycle parameters.}
}
\value{
An object of class \code{\link{uc}}.
}
\description{
\code{uc} creates an S3 object representing a predefined UC (trend, seasonal,
 cycle, autoregressive and irregular component).
}
\examples{
# Trend component
trend <- uc("trend", s2 = c(s2_lvl = 0.5, s2_slp = 0.025))
# Seasonal component
seas <- uc("seasonal", s2 = c(s2_seas = 0.5), s = 12, form = "trig")
# Cycle component
cycle1 <- uc("cycle", s2 = c(s2_c1 = 0.5), per = 5, phi = 0.8)
cycle2 <- uc("cycle", s2 = c(s2_c2 = 0.5), per = 10, phi = 0.8, counter = 2)

}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis by State Space
Methods, 2nd ed., Oxford University Press, Oxford.

Harvey, A.C. (1989) Forecasting, Structural Time Series Models and the Kalman
Filter. Cambridge University Press, Cambridge.
}
