% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_traits.R
\name{taxon_traits}
\alias{taxon_traits}
\alias{taxon_traits.taxlist}
\alias{taxon_traits,taxlist-method}
\alias{taxon_traits<-}
\alias{taxon_traits<-.taxlist}
\alias{taxon_traits<-,taxlist-method}
\alias{update_trait}
\alias{update_trait.taxlist}
\alias{update_trait,taxlist-method}
\title{Manipulation of taxon traits in taxlist objects.}
\usage{
taxon_traits(taxlist, ...)

\method{taxon_traits}{taxlist}(taxlist, ...)

taxon_traits(taxlist, ...) <- value

\method{taxon_traits}{taxlist}(taxlist, ...) <- value

update_trait(taxlist, ...)

\method{update_trait}{taxlist}(taxlist, taxonTraits, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments to be passed among methods.}

\item{value}{Data frame to be set as slot \code{taxonTraits}.}

\item{taxonTraits}{a data frame with taxon traits to be inserted in
\code{'taxlist'}. A column \code{'TaxonConceptID'} is mandatory in this table.
If some taxon concept IDs are not occurring in \code{'taxlist'}, an error
message is retrieved by \code{update_trait()}.}
}
\description{
The slot \code{taxonTraits} in \linkS4class{taxlist} objects contains
attributes of taxon concepts (e.g. functional traits).
These functions are suitable for replacing, retrieving and appending trait
information in taxonomic lists.
}
\details{
Taxon traits are contained in a data frame at the slot \code{taxonTraits} in
\linkS4class{taxlist} objects.
To optimise space, this data frame contain only entries for those concepts
with information, while taxa with no information are skipped from this table.
Thus appending new variables may also have to include new rows in this slot,
which is automatically carried out by this function.

The replacement method \verb{taxon_traits<-} should be only used when
constructing \linkS4class{taxlist} objects from an empty one.
}
\examples{
## Displaying taxon traits
head(taxon_traits(Easplist))

## Updating traits for Launaea cornuta
summary(Easplist, "Launaea cornuta")
accepted_name(taxlist = Easplist, ConceptID = 355, show_traits = TRUE)

sp_list <- update_trait(taxlist = Easplist, taxonTraits = data.frame(
        TaxonConceptID = 355,
        life_form = "annual"))
accepted_name(taxlist = sp_list, ConceptID = 355, show_traits = TRUE)
}
\seealso{
\linkS4class{taxlist}.
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
