% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tailplot.R
\name{gamma_tail}
\alias{gamma_tail}
\title{Estimate of tail functional g and confidence intervals for g and alpha}
\usage{
gamma_tail(
  x,
  d,
  confint = FALSE,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{d}{the threshold for the computation of g.}

\item{confint}{a boolean value indicating whether a confidence interval should be computed.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}
}
\value{
A matrix containing:
\item{threshold}{The value of the threshold d.}
\item{g.estimate}{Estimate of g.}
\item{g.ci1}{The lower bound of the confidence interval for g (if \code{confint = TRUE}).}
\item{g.ci2}{The upper bound of the confidence interval for g (if \code{confint = TRUE}).}
\item{alpha}{Estimate of the shape parameter under a gamma model.}
\item{alpha.ci1}{The lower bound of the confidence interval for alpha (if \code{confint = TRUE}).}
\item{alpha.ci2}{The upper bound of the confidence interval for alpha (if \code{confint = TRUE}).}
}
\description{
This function computes the estimate of \eqn{g} and the associated confidence interval for \eqn{g} as well as \eqn{alpha}, the corresponding shape parameter under the assumption of a gamma model, according to Iwashita and Klar (2024). Three methods are implemented to compute the confidence intervals: a method based on the unbiased variance estimators of the underlying U-statistics, and two resampling methods (jackknife and bootstrap).
}
\details{
The function \eqn{g} introduced by Asmussen and Lehtomaa (2017) is used to distinguish between
log-concave and log-convex tail behavior. It is defined as:

\deqn{ g(d) = E\left[ \frac{|X_1 - X_2|}{X_1 + X_2} \bigg| X_1 + X_2 > d \right] }

where \eqn{X_1, X_2} are independent and identically distributed (i.i.d.) positive random variables.
For gamma distributions, \eqn{g} takes a constant value, making it a useful tool for detecting gamma-tailed distributions.

This function estimates \eqn{g(d)} using U-statistics. The estimator \eqn{\hat{g}(d)} is given by:

\deqn{
\hat{g}(d) = \frac{ U^{(1)}_n (d) }{ U^{(2)}_n (d) }, \quad d > 0,  
}

where

\deqn{
U^{(1)}_n (d) = \frac{2}{n(n-1)} \sum_{1 \leq i < j \leq n} \frac{|X_i - X_j|}{X_i + X_j} 1(X_i + X_j > d),
}

\deqn{
U^{(2)}_n (d) = \frac{2}{n(n-1)} \sum_{1 \leq i < j \leq n} 1(X_i + X_j > d).
}

Confidence intervals for \eqn{g(d)}, based on the following variance estimation methods, are also provided:
\itemize{
\item Unbiased Variance Estimator
\item Bootstrap Resampling
\item Jackknife Resampling
}

The \eqn{(1-\gamma)} confidence interval for \eqn{\hat{g}_{n}(d)}
is given by:

\deqn{
  \left[
    \max\!\Bigl\{
      \hat{g}_{n}(d)\;-\;
      z_{1 - \gamma/2}
      \,\frac{\hat{\sigma}_{d}}{
        \sqrt{n\,U^{(2)}_{n}(d)}
      },
      \;0
    \Bigr\},
    \;\;
    \min\!\Bigl\{
      \hat{g}_{n}(d)\;+\;
      z_{1 - \gamma/2}
      \,\frac{\hat{\sigma}_{d}}{
        \sqrt{n\,U^{(2)}_{n}(d)}
      },
      \;1
    \Bigr\}
  \right].
}{
CI formula for g(d).  
}
Here,
\eqn{z_{1 - \gamma/2} = \Phi^{-1}(1 - \tfrac{\gamma}{2})} is the
appropriate quantile of the standard normal distribution and \eqn{\hat{\sigma}_d} is an estimator of the standard deviation based on one of the methods above.
}
\examples{
x <- rgamma(100, shape = 2, scale = 1)
gamma_tail(x, d = 2, confint = FALSE, method = "unbiased", R = 1000)

}
\references{
Iwashita, T. & Klar, B. (2024). A gamma tail statistic and its asymptotics. Statistica Neerlandica 78:2, 264-280.
\doi{https://doi.org/10.1111/stan.12316}

Asmussen, S. & Lehtomaa, J. (2017). Distinguishing Log-Concavity from Heavy Tails. \emph{Risks 2017, 5, 10}. \doi{https://doi.org/10.3390/risks5010010}
}
