% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chord_mapping.R
\name{lp_chord_id}
\alias{lp_chord_id}
\alias{lp_chord_mod}
\title{LilyPond chord notation}
\usage{
lp_chord_id(root, chord, exact = FALSE, ...)

lp_chord_mod(root, chord, exact = FALSE, ...)
}
\arguments{
\item{root}{character, root note.}

\item{chord}{character, \code{tabr} format chord name.}

\item{exact}{logical, return a more exact LilyPond chord representation.}

\item{...}{additional arguments passed to \code{transpose()}.}
}
\value{
character
}
\description{
Obtain LilyPond quasi-chord notation.
}
\details{
These functions take a \code{tabr} syntax representation of a chord name and
convert it to quasi-LilyPond syntax;
"quasi" because the result still uses \verb{_} for flats and \verb{#} for sharps,
whereas LilyPond itself uses \code{es} and \code{is} (mostly).
This is the format used by \code{tabr} functions involved in communicating with
LilyPond for music transcription, and they make these final conversions on
the fly.
This can be overridden with \code{exact = TRUE}.
}
\examples{
lp_chord_id("a a a", "m M m7_5")
lp_chord_mod("a a a", "m M m7_5")
lp_chord_id("a a a", "m M m7_5", exact = TRUE)
lp_chord_mod("a a a", "m M m7_5", exact = TRUE)
}
