% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_fallback.R
\name{font_fallback}
\alias{font_fallback}
\title{Get the fallback font for a given string}
\usage{
font_fallback(
  string,
  family = "",
  italic = FALSE,
  weight = "normal",
  width = "undefined",
  path = NULL,
  index = 0,
  variation = font_variation(),
  bold = deprecated()
)
}
\arguments{
\item{string}{The strings to find fallbacks for}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{path, index}{path and index of a font file to circumvent lookup based on
family and style}

\item{variation}{A \code{font_variation} object or a list of them to control
variable fonts}

\item{bold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{weight = "bold"} instead}
}
\value{
A data frame with a \code{path} and \code{index} column giving fallback for the
specified string and font combinations
}
\description{
A fallback font is a font to use as a substitute if the chosen font does not
contain the requested characters. Using font fallbacks means that the user
doesn't have to worry about mixing characters from different scripts or
mixing text and emojies. Fallback is calculated for the full string and the
result is platform specific. If no font covers all the characters in the
string an undefined "best match" is returned. The best approach is to figure
out which characters are not covered by your chosen font and figure out
fallbacks for these, rather than just request a fallback for the full string.
}
\examples{
font_fallback("\U0001f604") # Smile emoji

}
