% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.swaglm_network.R
\name{plot.swaglm_network}
\alias{plot.swaglm_network}
\title{plot.swaglm_network}
\usage{
\method{plot}{swaglm_network}(x, bins = 5, scale_edge = NULL, size_range = c(8, 30), ...)
}
\arguments{
\item{x}{An object of class \code{swaglm_network}}

\item{bins}{Number of bins for vertex size discretization (default = 5)}

\item{scale_edge}{Logical; whether to scale the edge width}

\item{size_range}{A numeric vector of length 2 specifying the range of node sizes.}

\item{...}{Additional arguments passed to \code{igraph::plot}}
}
\value{
None.
}
\description{
Visualizes a SWAG network with discretized vertex size, optional edge width scaling,
and edge coloring based on a correlation matrix.
}
\examples{
set.seed(12345)
n <- 2000
p <- 100

# create design matrix and vector of coefficients
Sigma <- diag(rep(1/p, p))
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma)
beta = c(-15,-10,5,10,15, rep(0,p-5))

# --------------------- generate from logistic regression with an intercept of one
z <- 1 + X\%*\%beta
pr <- 1/(1 + exp(-z))
y <- as.factor(rbinom(n, 1, pr))
y = as.numeric(y)-1

# define swag parameters
quantile_alpha = .15
p_max = 20
swag_obj = swaglm::swaglm(X=X, y = y, p_max = p_max, family = stats::binomial(), 
                          alpha = quantile_alpha, verbose = TRUE, seed = 123)
names(swag_obj)
swag_network = swaglm::compute_network(swag_obj)
names(swag_network)
plot(swag_network)
}
