% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_summary.R
\name{surv_summary}
\alias{surv_summary}
\title{Nice Summary of a Survival Curve}
\usage{
surv_summary(x, data = NULL)
}
\arguments{
\item{x}{an object of class survfit.}

\item{data}{a dataset used to fit survival curves. If not supplied then data
will be extracted from 'fit' object.}
}
\value{
An object of class \bold{'surv_summary'}, which is a data frame with
 the following columns: \itemize{ \item time: the time points at which the
 curve has a step. \item n.risk: the number of subjects at risk at t. \item
 n.event: the number of events that occur at time t. \item  n.censor: number
 of censored events. \item surv: estimate of survival. \item std.err:
 standard error of survival. \item upper: upper end of confidence interval.
 \item lower: lower end of confidence interval. \item strata: stratification of survival curves.}
 In a situation, where survival curves have been fitted with one or more
 variables, surv_summary object contains \bold{extra columns} representing the
 variables. This makes it possible to facet the output of
 \code{\link{ggsurvplot}} by strata or by some combinations of factors.

 surv_summary object has also an attribut named \bold{'table'} containing
 information about the survival curves, including medians of survival with
 confidence intervals, as well as, the total number of subjects and the
 number of event in each curve.
}
\description{
Compared to the default summary() function, surv_summary()
 creates a data frame containing a nice summary from
 \code{\link[survival]{survfit}} results.
}
\examples{

# Fit survival curves
require("survival")
fit <- survfit(Surv(time, status) ~ rx + adhere, data = colon)

# Summarize
res.sum <- surv_summary(fit, data = colon)
head(res.sum)

# Information about the survival curves
attr(res.sum, "table")


}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
