% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_median.R
\name{surv_median}
\alias{surv_median}
\title{Median of Survival Curves}
\usage{
surv_median(fit, combine = FALSE)
}
\arguments{
\item{fit}{A survfit object. Can be also a list of survfit objects.}

\item{combine}{logical value. Used only when fit is a list of survfit objects.
If TRUE, combine the results for multiple fits.}
}
\value{
Returns for each fit, a data frame with the following column:
 \itemize{ \item strata: strata/group names \item median: median survival of
 each group \item lower: 95\% lower confidence limit \item upper: 95\% upper
 confidence limit }Returns a list of data frames when the input is a
 list of survfit objects. If combine = TRUE, results are combined into one single data frame.
}
\description{
Returns the median survival with upper and lower confidence
 limits for the median at 95\% confidence levels.
}
\examples{

library(survival)

# Different survfits
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::
fit.null <- surv_fit(Surv(time, status) ~ 1, data = colon)

fit1 <- surv_fit(Surv(time, status) ~ sex, data = colon)

fit2 <- surv_fit(Surv(time, status) ~ adhere, data = colon)

fit.list <- list(sex = fit1, adhere = fit2)

# Extract the median survival
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::
surv_median(fit.null)

surv_median(fit2)

surv_median(fit.list)

surv_median(fit.list, combine = TRUE)

# Grouped survfit
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::
fit.list2 <- surv_fit(Surv(time, status) ~ sex, data = colon,
                     group.by = "rx")
surv_median(fit.list2)
}
