## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----basic-usage--------------------------------------------------------------
# library(shiny)
# library(bslib)
# library(sunburstShinyWidget)
# 
# chartData <- jsonlite::read_json("path/to/chartData.json")
# design <- jsonlite::read_json("path/to/design.json")
# 
# ui <- page_sidebar(
#   title = "Sunburst plot",
#   sidebar = sidebar(open = FALSE),
#   sunburstUI("my_plot")
# )
# 
# server <- function(input, output) {
#   sunburstServer("my_plot", chartData, design)
# }
# 
# shinyApp(ui, server)

## ----server-params------------------------------------------------------------
# sunburstServer(
#   id = "my_plot",
#   chartData = chartData,
#   design = design,
#   btn_font_size = "14px",                    # Font size for colored cohort buttons
#   show_colors_in_table = FALSE,              # TRUE = colored buttons in steps table
#   steps_table_export_name = reactive(NULL),  # Custom CSV export filename
#   n_steps = reactive(5L)                     # Number of steps shown in the table
# )

## ----dynamic-steps------------------------------------------------------------
# server <- function(input, output) {
#   sunburstServer(
#     "my_plot", chartData, design,
#     n_steps = reactive(input$step_slider)
#   )
# }

## ----custom-filename----------------------------------------------------------
# sunburstServer(
#   "my_plot", chartData, design,
#   steps_table_export_name = reactive("my_analysis_steps.csv")
# )

## ----low-level----------------------------------------------------------------
# ui <- fluidPage(
#   sunburstShinyWidgetOutput("my_sunburst", height = "600px")
# )
# 
# server <- function(input, output) {
#   output$my_sunburst <- renderSunburstShinyWidget({
#     sunburstShinyWidget(chartData, design)
#   })
# }

## ----chartdata-structure------------------------------------------------------
# list(
#   eventCodes = list(
#     list(code = 1L, name = "Glipizide-txp", isCombo = FALSE),
#     list(code = 2L, name = "Metformin-txp", isCombo = FALSE),
#     list(code = 4L, name = "Simvastatin-txp", isCombo = FALSE),
#     list(code = 3L, name = "Glipizide-txp,Metformin-txp", isCombo = TRUE)
#   ),
#   pathwayGroups = list(
#     list(
#       targetCohortId = 1781666L,
#       targetCohortCount = 756L,
#       totalPathwaysCount = 366L,
#       pathways = list(
#         list(path = "4-end", personCount = 115L),
#         list(path = "4-2-end", personCount = 35L),
#         list(path = "2-end", personCount = 35L)
#       )
#     )
#   )
# )

## ----design-structure---------------------------------------------------------
# list(
#   name = "IQT-Pathways",
#   targetCohorts = list(
#     list(id = 1781666L, name = "T2DM Treatment group")
#   ),
#   eventCohorts = list(
#     list(id = 1789987L, name = "Glipizide-txp"),
#     list(id = 1789986L, name = "Metformin-txp"),
#     list(id = 1789985L, name = "Simvastatin-txp")
#   ),
#   combinationWindow = 3L,
#   maxDepth = 5L
# )

## ----read-atlas-export--------------------------------------------------------
# full_export <- jsonlite::read_json("PathwayDesignData.json")
# chartData <- full_export$data
# design <- full_export$design

## ----read-sample--------------------------------------------------------------
# chartData <- jsonlite::read_json(
#   system.file("extdata", "chartData.json", package = "sunburstShinyWidget")
# )
# design <- jsonlite::read_json(
#   system.file("extdata", "design.json", package = "sunburstShinyWidget")
# )

## ----larger-app---------------------------------------------------------------
# ui <- page_navbar(
#   title = "My Analysis Dashboard",
#   nav_panel("Overview", "Summary stats here..."),
#   nav_panel("Pathways",
#     layout_columns(
#       col_widths = 12,
#       sunburstUI("pathways")
#     )
#   ),
#   nav_panel("Details", "Other analysis outputs...")
# )
# 
# server <- function(input, output) {
#   sunburstServer("pathways", chartData, design)
# }

## ----multiple-modules---------------------------------------------------------
# ui <- page_fluid(
#   h3("Cohort A"),
#   sunburstUI("cohort_a"),
#   h3("Cohort B"),
#   sunburstUI("cohort_b")
# )
# 
# server <- function(input, output) {
#   sunburstServer("cohort_a", chartData_a, design_a)
#   sunburstServer("cohort_b", chartData_b, design_b)
# }

## ----helper-remain------------------------------------------------------------
# df <- data.frame(Name = c("Step 1", "Step 2"), Remain = c(300, 180))
# add_remain_and_diff_cols(df, totalPathways = 756)
# #>     Name          Remain            Diff
# #> 1 Step 1 300 (39.7%) 456 (60.3%)
# #> 2 Step 2 180 (23.8%) 120 (15.9%)

## ----helper-button------------------------------------------------------------
# customActionButton("btn1", "Metformin", "#1f77b4", font_size = "12px")

