

"read_dictionary" <- function(file=NULL, verbose=TRUE){

  if(is.null(file)){
    file  <- system.file("extdata", "sumer-dictionary.txt", package = "sumer")
  }

  dic <- read.table(
         file,
         sep = ";",
         header = TRUE,
         comment.char = "#",
         na.strings="",
         quote="",
         stringsAsFactors = FALSE,
         fileEncoding = "UTF-8"
     )

 dic$type[is.na(dic$type)]<-""

 if(verbose){
  meta <- readLines(file, n=20)
  meta <- meta[grepl("^###", meta)]
  meta <- paste0(meta, "\n")
  meta[1] <- paste0(" ", meta[1])
  cat(meta)
 }

 dic
}

