% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadForestContainerCombinedJson}
\alias{loadForestContainerCombinedJson}
\title{Combine JSON Model Objects into ForestSamples}
\usage{
loadForestContainerCombinedJson(json_object_list, json_forest_label)
}
\arguments{
\item{json_object_list}{List of objects of class \code{CppJson}}

\item{json_forest_label}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy (must exist in every json object in the list)}
}
\value{
\code{ForestSamples} object
}
\description{
Combine multiple JSON model objects containing forests (with the same hierarchy / schema) into a single forest_container

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
bart_model <- bart(X, y, num_gfr=0, num_mcmc=10)
bart_json <- list(saveBARTModelToJson(bart_model))
mean_forest <- loadForestContainerCombinedJson(bart_json, "forest_0")
}
