% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{extract_parameter}
\alias{extract_parameter}
\title{Extract Parameter Samples Generic Function}
\usage{
extract_parameter(object, term)
}
\arguments{
\item{object}{Fitted model object from which to extract parameter samples}

\item{term}{Name of the parameter to extract (e.g., \code{"sigma2"}, \code{"y_hat_train"}, etc.)}
}
\value{
Parameter sample array
}
\description{
Generic function for extracting parameter samples from a model object (BCF, BART, etc...)
}
\examples{
n <- 100
p <- 10
X <- matrix(runif(n*p), ncol = p)
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- rep(1.0, n)
y <- (-5 + 10*(X[,1] > 0.5)) + (-2*(rfx_group_ids==1)+2*(rfx_group_ids==2)) + rnorm(n)
bart_model <- bart(X_train=X, y_train=y, rfx_group_ids_train=rfx_group_ids,
                   rfx_basis_train = rfx_basis, num_gfr=0, num_mcmc=10)
sigma2_samples <- extract_parameter(bart_model, "sigma2")
}
