% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_basic_plots.R
\name{base_cdf}
\alias{base_cdf}
\title{Graphical representation of fitted distribution(s)}
\usage{
base_cdf(fits, unit, logscale, names = NULL, horizontals = TRUE, xlim = NULL)
}
\arguments{
\item{fits}{A list of fits of class \code{fitdist} or \code{fitdistcens}
computed from the same toxicity data.}

\item{unit}{A character vector, the unit of the toxicity data}

\item{logscale}{if \code{TRUE}, uses a logarithmic scale for the \eqn{x}-axis}

\item{names}{Label vector for data points (only for non censored data)}

\item{horizontals}{If \code{TRUE}, draws horizontal lines for the step empirical 
  cumulative distribution function (ecdf). See also \code{\link{plot.stepfun}}.}

\item{xlim}{The \eqn{x}-limits of the plot.}
}
\value{
A ggplot object.
}
\description{
\code{base_cdf} plots an empirical cdf of the toxicity values against one or
several fitted distributions' cdf. It works for both censored and non
censored data.
}
