% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_disconnect.R
\name{db_disconnect}
\alias{db_disconnect}
\title{Disconnect from a SQL Server connection or pool}
\usage{
db_disconnect(conn, quiet = FALSE)
}
\arguments{
\item{conn}{A DBI connection or a pool connection object}

\item{quiet}{(logical) if TRUE, suppresses messages}
}
\value{
TRUE (invisibly) if disconnected, FALSE otherwise
}
\description{
Disconnect from a SQL Server connection or pool
}
\examples{
\donttest{
# Establish a connection
conn <- db_connect(
  server   = "localhost",
  database = "master",
  quiet    = TRUE
)

# Disconnect when finished
db_disconnect(conn)

# Disconnecting a NULL connection
db_disconnect(NULL)
}

}
