% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R, R/residuals_glm.R
\name{residuals.spmodel}
\alias{residuals.spmodel}
\alias{residuals.splm}
\alias{resid.splm}
\alias{rstandard.splm}
\alias{residuals.spautor}
\alias{resid.spautor}
\alias{rstandard.spautor}
\alias{residuals.spglm}
\alias{resid.spglm}
\alias{rstandard.spglm}
\alias{residuals.spgautor}
\alias{resid.spgautor}
\alias{rstandard.spgautor}
\title{Extract fitted model residuals}
\usage{
\method{residuals}{splm}(object, type = "response", ...)

\method{resid}{splm}(object, type = "response", ...)

\method{rstandard}{splm}(model, ...)

\method{residuals}{spautor}(object, type = "response", ...)

\method{resid}{spautor}(object, type = "response", ...)

\method{rstandard}{spautor}(model, ...)

\method{residuals}{spglm}(object, type = "deviance", ...)

\method{resid}{spglm}(object, type = "deviance", ...)

\method{rstandard}{spglm}(model, ...)

\method{residuals}{spgautor}(object, type = "deviance", ...)

\method{resid}{spgautor}(object, type = "deviance", ...)

\method{rstandard}{spgautor}(model, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{type}{\code{"response"} for response residuals, \code{"pearson"}
for Pearson residuals, or \code{"standardized"} for standardized residuals.
For \code{\link[=splm]{splm()}} and \code{\link[=spautor]{spautor()}} fitted model objects, the default is \code{"response"}.
For \code{\link[=spglm]{spglm()}} and \code{\link[=spgautor]{spgautor()}} fitted model objects, deviance residuals are
also available (\code{"deviance"}) and are the default residual type.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{model}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}
}
\value{
The residuals as a numeric vector.
}
\description{
Extract residuals from a fitted model object.
\code{resid} is an alias.
}
\details{
The response residuals are taken as the response minus the fitted values
for the response: \eqn{y - X \hat{\beta}}. The Pearson residuals are the
response residuals pre-multiplied by their inverse square root.
The standardized residuals are Pearson residuals divided by the square
root of one minus the leverage (hat) value. The standardized residuals are often used to
check model assumptions, as they have mean zero and variance approximately one.

\code{rstandard()} is an alias for \code{residuals(model, type = "standardized")}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
residuals(spmod)
resid(spmod)
residuals(spmod, type = "pearson")
residuals(spmod, type = "standardized")
rstandard(spmod)
}
\seealso{
\code{\link[=augment.spmodel]{augment.spmodel()}} \code{\link[=cooks.distance.spmodel]{cooks.distance.spmodel()}} \code{\link[=hatvalues.spmodel]{hatvalues.spmodel()}} \code{\link[=influence.spmodel]{influence.spmodel()}}
}
