% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs_analysis_subgroup.R
\docType{class}
\name{splinetrials_subgroup_analysis-class}
\alias{splinetrials_subgroup_analysis-class}
\title{\code{splinetrials_subgroup_analysis} object}
\description{
\code{ncs_analysis_subgroup()} returns an object of class
\code{splinetrials_subgroup_analysis}: a named \link{list} with three to seven elements.
}
\section{\code{between} and \code{within}}{
These are each \code{\link[dplyr:reexports]{tibbles}}, and they share many of the same
columns and values but are sorted in a different order. Each contains one row
per unique combination of \code{arm}, \code{time_scheduled_label}, and \code{subgroup} found
in the \code{data} (see the arguments of \code{\link[=ncs_analysis_subgroup]{ncs_analysis_subgroup()}}). The values
in columns \code{arm} through \code{change_p_value} as well as \code{correlation} and
\code{optimizer} are identical. The two tables' treatment effect analysis results
columns differ in name and content, with \code{between}'s columns bearing the
prefix \code{diff_subgroup_} and \code{within}'s columns bearing the prefix \code{diff_arm_}
(see the \strong{Treatment effects} section of \code{\link[=ncs_analysis_subgroup]{ncs_analysis_subgroup()}}).
Lastly, only \code{within} contains the percent slowing analysis results.
\subsection{\code{between}}{

A 30-column \code{\link[dplyr:reexports]{tibble}} sorted by \code{time}, then by \code{arm}, then
by \code{subgroup}.

Columns:
\enumerate{
\item \code{arm}: values of \code{data[[arm]]}.
\item \code{time}: values of \code{data[[time_scheduled_label]]}.
\item \code{subgroup}: values of \code{data[[subgroup]]}.
\item \code{n}: number of times the combination appears in data.
\item \code{est}: \link{mean} of \code{data[[response]]}.
\item \code{sd}: \link[=sd]{standard deviation} of \code{data[[response]]}.
\item \code{se}: standard error of \code{data[[response]]} (i.e., \code{sd / sqrt(n)}).
\item \code{lower}: lower bound of confidence interval.
\item \code{upper}: upper bound of confidence interval.
\item \code{response_est}: estimated marginal mean.
\item \code{response_se}: standard error of \code{response_est}.
\item \code{response_df}: degrees of freedom used to calculate the confidence
interval for \code{response_est}.
\item \code{response_lower}: lower bound of confidence interval for \code{response_est}.
\item \code{response_upper}: upper bound of confidence interval for \code{response_est}.
\item \code{change_est}: estimated change from baseline.
\item \code{change_se}: standard error of \code{change_est}.
\item \code{change_df}: degrees of freedom used for calculating the confidence
interval for and testing the significance of \code{change_est}.
\item \code{change_lower}: lower bound of confidence interval for \code{change_est}.
\item \code{change_upper}: upper bound of confidence interval for \code{change_est}.
\item \code{change_test_statistic}: test statistic measuring the significance of
\code{change_est}.
\item \code{change_p_value}: p-value for the significance of \code{change_est}.
\item \code{diff_subgroup_est}: treatment effect of \code{subgroup} within \code{arm}.
\item \code{diff_subgroup_se}: standard error of \code{diff_subgroup_est}.
\item \code{diff_subgroup_df}: degrees of freedom used for calculating the confidence
interval for and testing the significance of \code{diff_subgroup_est}.
\item \code{diff_subgroup_lower}: lower bound of confidence interval for
\code{diff_subgroup_est}.
\item \code{diff_subgroup_upper}: upper bound of confidence interval for
\code{diff_subgroup_est}.
\item \code{diff_subgroup_test_statistic}: test statistic measuring the significance
of \code{diff_subgroup_est}.
\item \code{diff_subgroup_p_value}: p-value for the significance of
\code{diff_subgroup_est}.
\item \code{correlation}: the covariance structure of the analysis model. This is the
same value repeated for each row.
\item \code{optimizer}: invariably \code{mmrm+tmb} to indicate that \code{\link[mmrm:mmrm]{mmrm::mmrm()}} (which
uses the \code{TMB} package) was used to fit the model.
}
}
}

\section{\code{within}}{
A 33-column \code{\link[dplyr:reexports]{tibble}} sorted by \code{subgroup}, then by \code{arm},
then by \code{time}.

Columns:
\enumerate{
\item \code{arm}: values of \code{data[[arm]]}.
\item \code{time}: values of \code{data[[time_scheduled_label]]}.
\item \code{subgroup}: values of \code{data[[subgroup]]}.
\item \code{n}: number of times the combination appears in data.
\item \code{est}: \link{mean} of \code{data[[response]]}.
\item \code{sd}: \link[=sd]{standard deviation} of \code{data[[response]]}.
\item \code{se}: standard error of \code{data[[response]]} (i.e., \code{sd / sqrt(n)}).
\item \code{lower}: lower bound of confidence interval.
\item \code{upper}: upper bound of confidence interval.
\item \code{response_est}: estimated marginal mean.
\item \code{response_se}: standard error of \code{response_est}.
\item \code{response_df}: degrees of freedom used for calculating the confidence
interval for \code{response_est}.
\item \code{response_lower}: lower bound of confidence interval for \code{response_est}.
\item \code{response_upper}: upper bound of confidence interval for \code{response_est}.
\item \code{change_est}: estimated change from baseline.
\item \code{change_se}: standard error of \code{change_est}.
\item \code{change_df}: degrees of freedom for calculating the confidence interval
for and estimating the significance of \code{change_est}.
\item \code{change_lower}: lower bound of confidence interval for \code{change_est}.
\item \code{change_upper}: upper bound of confidence interval for \code{change_est}.
\item \code{change_test_statistic}: test statistic measuring the significance of
\code{change_est}.
\item \code{change_p_value}: p-value for the significance of \code{change_est}.
\item \code{diff_arm_est}: treatment effect of \code{arm} within \code{subgroup}.
\item \code{diff_arm_se}: standard error of \code{diff_arm_est}.
\item \code{diff_arm_df}: degrees of freedom for calculating the confidence interval
for and testing the significance of \code{diff_arm_est}.
\item \code{diff_arm_lower}: lower bound of confidence interval for \code{diff_arm_est}.
\item \code{diff_arm_upper}: upper bound of confidence interval for \code{diff_arm_est}.
\item \code{diff_arm_test_statistic}: test statistic measuring the significance of
\code{diff_arm_est}.
\item \code{diff_arm_p_value}: p-value for the significance of \code{diff_arm_est}.
\item \code{percent_slowing_est}: estimated percent slowing.
\item \code{percent_slowing_lower}: lower bound of confidence interval for
\code{percent_slowing_est}.
\item \code{percent_slowing_upper}: upper bound of confidence interval for
\code{percent_slowing_est}.
\item \code{correlation}: the covariance structure of the analysis model. This is the
same value repeated for each row.
\item \code{optimizer}: invariably \code{mmrm+tmb} to indicate that \code{\link[mmrm:mmrm]{mmrm::mmrm()}} (which
uses the \code{TMB} package) was used to fit the model.
}
}

\section{\code{type3}}{
A \code{\link[dplyr:reexports]{tibble}} with a row for each term in the model (not
counting any intercepts). Contains the following six columns:
\enumerate{
\item \code{effect}: the name of the model term.
\item \code{chisquare_test_statistic}: the Chi-squared test statistic measuring the
significance of the model term.
\item \code{df}: the degrees of freedom used for testing the significance of the
model term.
\item \code{p_value}: the p-value for the significance of the model term.
\item \code{correlation}: the covariance structure of the analysis model. This is the
same value repeated for each row.
\item \code{optimizer}: invariably \code{mmrm+tmb} to indicate that \code{\link[mmrm:mmrm]{mmrm::mmrm()}} (which
uses the \code{TMB} package) was used to fit the model.
}
}

\section{\code{interaction}}{
This element is only present if \code{subgroup_interaction_test = TRUE}.

A 2 by 10 data frame with class \code{anova.mmrm}. The first row represents the
"reduced" model and the second row represents the "full" model. The columns
are as follows:
\enumerate{
\item \code{model}: \code{c("reduced model", "full model")}, identifying the model
associated with each row.
\item \code{aic}: the \link{AIC} of the model.
\item \code{bic}: the \link{BIC} of the model.
\item \code{loglik}: the \link[stats:logLik]{log likelihood} of the model.
\item \code{-2*log(l)}: equal to \code{-2 * loglik}.
\item \code{test_statistic}: the test statistic used for testing the significance of
the second-order interaction term(s) between the spline time, \code{subgroup}, and
\code{arm}. This value is the second element of the column; the first element is
always a missing value.
\item \code{df}: the degrees of freedom used for testing the significance of the
second-order interaction term(s) between the spline term, \code{subgroup}, and
\code{arm}. This value is the second element of the column; the first element is
always a missing value.
\item \code{p_value}: the p-value for the significance of the second-order
interaction term(s) between the spline term, \code{subgroup}, and \code{arm}. This
value is the second element of the column; the first element is always a
missing value.
\item \code{correlation}: the covariance structure of the analysis model. This is the
same value repeated for each row.
\item \code{optimizer}: invariably \code{mmrm+tmb} to indicate that \code{\link[mmrm:mmrm]{mmrm::mmrm()}} (which
uses the \code{TMB} package) was used to fit the model.
}
}

\section{\code{analysis_model}}{
This element is only present if \code{return_models = TRUE}.

An \code{\link[mmrm:mmrm]{mmrm}} object: the fitted model used to perform analyses
that produced the \code{between}, \code{within}, and \code{type3} results.
}

\section{\code{full} and \code{reduced}}{
These elements are only present if \code{subgroup_interaction_test = TRUE} and
\code{return_models = TRUE}.

Both are \code{\link[mmrm:mmrm]{mmrm}} objects: the two maximum-likelihood-estimated
models used to perform the subgroup interaction test whose results are in the
\code{interaction} element. See the \strong{Subgroup interaction test} section of
\code{\link[=ncs_analysis_subgroup]{ncs_analysis_subgroup()}}.
}

\seealso{
The function \code{\link[=ncs_analysis_subgroup]{ncs_analysis_subgroup()}}, which produces objects of
this class.
}
