% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs_mmrm_fit.R
\name{ncs_mmrm_fit}
\alias{ncs_mmrm_fit}
\title{Create a Mixed Model with Repeated Measures Using Natural Cubic Splines.}
\usage{
ncs_mmrm_fit(
  data,
  type = c("basic", "subgroup_full", "subgroup_reduced"),
  response,
  subject,
  cov_structs = c("us", "toeph", "ar1h", "csh", "cs"),
  cov_struct_group = NULL,
  time_observed_continuous,
  df = 2,
  spline_basis = NULL,
  time_observed_index,
  time_scheduled_continuous = NULL,
  arm = NULL,
  control_group = "control",
  subgroup = NULL,
  subgroup_comparator = NULL,
  covariates = ~1,
  expand_spline_terms = TRUE,
  mmrm_args = list(method = "Satterthwaite"),
  ...
)
}
\arguments{
\item{data}{(\verb{data frame})\cr data set supplied to the \code{data} argument of
\code{\link[mmrm:mmrm]{mmrm::mmrm()}} when fitting models. The supplied expression is
\link[rlang:enquo]{quoted} and must evaluate to a data frame. See \strong{Tidy
evaluation support}.}

\item{type}{(\code{string})\cr one of \code{"basic"}, \code{"subgroup_full"}, or
\code{"subgroup_reduced"}.}

\item{response}{(\code{numeric} or \code{string})\cr the response variable. It can be a
\code{string} identifying the name of an existing variable; otherwise, the
supplied expression will be \link[rlang:enquo]{quoted} and added to the formula
as is (see \strong{Tidy evaluation support}).}

\item{subject}{(\code{atomic} or \code{string})\cr the unique subject identifier
forwarded to the \code{subject} argument of \code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. Ignored if
\code{cov_structs} is a \code{list}. Can be a \code{string} identifying an existing
variable; otherwise the supplied expression will be \link[rlang:enquo]{quoted}
and turned into a \code{string} with \code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy
evaluation support}).}

\item{cov_structs}{(\code{character} or \code{list})\cr either a \code{list} of unique
\code{\link[mmrm:cov_struct]{cov_struct}} objects or a \code{character} vector of one or
more of the covariance structure abbreviations as described in
\code{\link[mmrm:covariance_types]{mmrm::cov_types()}}. These covariance structures will be attempted in order
until one of them achieves a converging model fit. Defaults to \code{c("us", "toeph", "ar1h", "csh", "cs")}.}

\item{cov_struct_group}{(\code{atomic} or \code{string})\cr optional grouping variable
to be passed to the \code{group} argument of \code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. It can be a
\code{string} identifying an existing variable name; otherwise the supplied
expression will be \link[rlang:enquo]{quoted} and turned into a \code{string} with
\code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy evaluation support}). Ignored if
\code{cov_structs} is a \code{list}. Defaults to \code{NULL}, in which case no grouping
variable will be used.}

\item{time_observed_continuous}{(\code{numeric} or \code{string})\cr the visit's
\emph{observed} time point. It must either be a \code{string} or a \link{name} identifying
an existing variable (i.e., it cannot be a \link{call}). If a name is provided,
it is \link[rlang:enquo]{quoted} and incorporated into the model formula as is
(see \strong{Tidy evaluation support}).}

\item{df}{(scalar \code{integer})\cr number of degrees of freedom to use to create
the spline basis. Passed to the \code{df} argument of \code{\link[=time_spline_basis]{time_spline_basis()}}.
Ignored if the \code{spline_basis} argument is not \code{NULL}.}

\item{spline_basis}{(\code{basis} \code{matrix})\cr a spline basis: probably a value
returned by \code{\link[=time_spline_basis]{time_spline_basis()}} (which wraps \code{\link[splines:ns]{splines::ns()}}). If \code{NULL}
(the default), then the spline basis will be the result of forwarding
\code{time_observed_continuous} and \code{df} to \code{\link[=time_spline_basis]{time_spline_basis()}}. See
\strong{Providing a spline basis}.}

\item{time_observed_index}{(\code{ordered} or \code{string})\cr the visit index that
the visit shall be associated with, based on the visit's \emph{observed} time
point. This will be passed as the \code{visits} argument of
\code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. It can be a \code{string} identifying an existing
variable; otherwise the supplied expression will be \link[rlang:enquo]{quoted}
and turned into a \code{string} with \code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy
evaluation support}). If it does not evaluate to an \code{ordered} factor, it
will be wrapped with \code{\link[=as.ordered]{as.ordered()}}. Ignored if \code{cov_structs} is a \code{list}.}

\item{time_scheduled_continuous}{(\code{numeric} or \code{string})\cr the continuous
time point when the visit was \emph{scheduled} to occur. Its unique values will
identify the time points at which the marginal means and other results will
be calculated. It can be a \code{string} identifying an existing variable name;
otherwise the supplied expression will be \link[rlang:enquo]{quoted} before
being evaluated (see \strong{Tidy evaluation support}).}

\item{arm}{(\code{factor} or \code{string})\cr the study arm. It must be a \code{string} or
a \link{name} identifying an existing variable (i.e., it cannot be a \link{call}). If
a name, it will be \link[rlang:enquo]{quoted} before being added to the model
formula (see \strong{Tidy evaluation support}). If it does not evaluate to a
\link{factor} or if \code{control_group} is not its first \link[=levels]{level}, the \code{data}
argument will be wrapped in a \code{\link[dplyr:mutate]{dplyr::mutate()}} call that forces this to be
the case.}

\item{control_group}{(\code{string})\cr the value in \code{arm} denoting the control
group. If necessary, \code{arm} will be preprocessed such that it is a factor
with \code{control_group} as its first level.}

\item{subgroup}{(\code{factor} or \code{string})\cr the subgroup. It must be a \code{string}
or a \link{name} identifying an existing variable (i.e., it cannot be a \link{call}).
If a name, it will be \link[rlang:enquo]{quoted} before being added to the
model formula (see \strong{Tidy evaluation support}). If it does not evaluate to
a \link{factor} or if \code{subgroup_comparator} is not its first \link[=levels]{level},
the \code{data} argument will be wrapped in a \code{\link[dplyr:mutate]{dplyr::mutate()}} call that forces
this to be the case.}

\item{subgroup_comparator}{(\code{string})\cr the value in \code{subgroup} denoting the
"main" subgroup that all other subgroups should be compared to. If
necessary, \code{subgroup} will be preprocessed such that it is a factor with
\code{control_group} as its first level.}

\item{covariates}{(\code{formula})\cr formula containing additional terms that
should be added to the \code{mmrm} model. Defaults to \code{~ 1}, in which no
additional terms will be added. Must not have a left side. Cannot contain
\code{.}. To specify that the model shall not have an intercept, use include \code{+ 0} or \code{- 1} in this formula.}

\item{expand_spline_terms}{(\code{flag})\cr flag indicating whether or not to
separate the cubic spline matrix into separate terms (one for each degree
of freedom). Defaults to \code{TRUE}. See \strong{Expanding spline terms}.}

\item{mmrm_args}{(named \code{list})\cr arguments to be passed to \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
If any elements have the names \code{formula}, \code{data}, or \code{covariance} they will
be ignored. An element named \code{vcov} will also be ignored unless fitting a
model with an unstructured covariance. Defaults to \code{list(method = "Satterthwaite")}.}

\item{...}{additional arguments to be passed to \code{\link[mmrm:mmrm]{mmrm::mmrm()}}. If any
elements have the names \code{formula}, \code{data}, or \code{covariance} they will be
ignored. An element named \code{vcov} will also be ignored unless fitting a
model with an unstructured covariance. Defaults to \code{list(method = "Satterthwaite")}. Arguments named in \code{mmrm_args} supersede any named
arguments in \code{...}.}
}
\value{
An \code{mmrm} object created by \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
}
\description{
Builds an \code{\link[mmrm:mmrm]{mmrm}} model that includes a study arm,
optionally a subgroup, and natural cubic splines applied to a continuous
time variable. A wrapper around \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.

Constructs a call to \code{\link[mmrm:mmrm]{mmrm::mmrm()}} for ncs analysis. Implements natural
cubic splines for the continuous time variable. Attempts a sequence of
covariance structures in order until one of them successfully converges.
Title
}
\section{Providing a spline basis}{
This function's \code{spline_basis} argument was designed with \code{\link[splines:ns]{splines::ns()}} in
mind, which creates a matrix object with classes \code{basis} and \code{matrix} as well
as multiple attributes. In theory, \code{spline_basis} does not have to be a
\code{matrix}; however, it still must have a \code{\link[stats:predict]{stats::predict()}} method wherein
\code{stats::predict(spline_basis, data[[time_observed_continuous]])} produces an
object that can serve as a term in the model.
}

\section{Covariance structures}{
The user specifies covariance structure \emph{candidates} via the \code{cov_structs}
argument. These structures will be attempted in order until a model converges
successfully.

When any covariance structure other than \code{"us"} (heterogeneous unstructured)
is used, \code{"Empirical-Bias-Reduced"} is passed to \code{\link[mmrm:mmrm]{mmrm::mmrm()}} as the \code{vcov}
argument (see \code{\link[mmrm:mmrm_control]{mmrm::mmrm_control()}}).

When fitting models, these analysis functions specify the covariance
structure through the \code{covariance} argument of \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
}

\section{Building the model formula}{
These analysis functions automatically build the model formula from its
arguments. The user cannot remove any of these auto-generated terms, but
terms can be added via the \code{covariates} argument.
\subsection{Time spline terms}{

Natural cubic splines will be applied to the \code{time_observed_continuous}
variable in \code{data}. These splines will be constructed according to the
user-specified \code{spline_basis}. A custom \code{spline_fn()} is constructed under
the hood that accepts \code{time_observed_continuous} and produces a spline matrix
based on the \code{spline_basis}. Thus, the model formula includes a time spline
term resembling \code{spline_fn(time_observed_continuous)}.
}

\subsection{\code{arm} and \code{subgroup} terms}{

All generated models include an interaction term between the time spline term
and the study \code{arm} term, but \code{arm} is not included as a main effect by
default. If this is desired, use the \code{covariates} argument (e.g., specify
\code{covariates = ~ arm}).

Concerning \code{ncs_analysis_subgroup()}, the \code{subgroup} variable is included as
a main effect, and its interaction with the time spline is also included.
Furthermore, the second-order interaction term between the time spline,
\code{subgroup}, and \code{arm} is also included for the main analysis model and the
"full" model (when \code{subgroup_interaction_test = TRUE}; see \strong{Subgroup
interaction test} below).
}

\subsection{Adding terms with \code{covariates}}{

The user can specify additional terms through the \code{covariates} argument,
which must be a formula.

The user cannot specify the covariance structure with this argument. See the
\strong{Covariance structures} section above.

The user can remove the intercept from the model by including \code{0} as a term
in \code{covariates}.
}

\subsection{Model formula templates}{

The model formulas that the analysis functions construct will take the form
of the formula templates below.
\subsection{\code{ncs_analysis()} (i.e., no subgroup)}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{response ~
  spline_fn(time_observed_continuous) +
  spline_fn(time_observed_continuous):arm \{+
  covariates\}
}\if{html}{\out{</div>}}
}

\subsection{\code{ncs_analysis_subgroup()}}{

Main analysis model and "full" model:

\if{html}{\out{<div class="sourceCode">}}\preformatted{response ~
  spline_fn(time_observed_continuous) +
  subgroup +
  spline_fn(time_observed_continuous):subgroup +
  spline_fn(time_observed_continuous):arm +
  spline_fn(time_observed_continuous):subgroup:arm \{+
  covariates\}
}\if{html}{\out{</div>}}

"reduced" model:

\if{html}{\out{<div class="sourceCode">}}\preformatted{response ~
  spline_fn(time_observed_continuous) +
  subgroup +
  spline_fn(time_observed_continuous):subgroup +
  spline_fn(time_observed_continuous):arm \{+
  covariates\}
}\if{html}{\out{</div>}}
}

}

\subsection{Expanding spline terms}{

When \code{expand_spline_terms = TRUE} and \code{spline_basis} has at least two
\link{dim}ensions (e.g., if it is a matrix, which is typical), the spline term
will be split into multiple terms: one for each of its columns.

For instance, if the user specifies a \code{spline_basis} with 3 degrees of
freedom, the above no-subgroup model formula template would become:

\if{html}{\out{<div class="sourceCode">}}\preformatted{response ~
  spline_fn(time_observed_continuous)[, 1] +
  spline_fn(time_observed_continuous)[, 2] +
  spline_fn(time_observed_continuous)[, 3] +
  spline_fn(time_observed_continuous)[, 1]:arm +
  spline_fn(time_observed_continuous)[, 2]:arm +
  spline_fn(time_observed_continuous)[, 3]:arm \{+
  covariates\}
}\if{html}{\out{</div>}}
}
}

\examples{
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

# Example without subgroup:
ncs_mmrm_fit(
  data = fev_mod,
  type = "basic",
  response = FEV1,
  subject = USUBJID,
  cov_structs = c("ar1", "us"),
  time_observed_continuous = time_cont,
  df = 2,
  time_observed_index = obs_visit_index,
  time_scheduled_continuous = VISITN,
  arm = ARMCD,
  control_group = "PBO",
  covariates = ~ FEV1_BL + RACE
)

# Example with subgroup:
ncs_mmrm_fit(
  data = fev_mod,
  type = "subgroup_full",
  response = FEV1,
  subject = USUBJID,
  cov_structs = c("ar1", "us"),
  time_observed_continuous = time_cont,
  df = 2,
  time_observed_index = obs_visit_index,
  time_scheduled_continuous = VISITN,
  arm = ARMCD,
  control_group = "PBO",
  subgroup = SEX,
  subgroup_comparator = "Male",
  covariates = ~ FEV1_BL + RACE
)
}
