% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{counting_rule_holds}
\alias{counting_rule_holds}
\title{Verify that the counting rule CR(r,1) holds}
\usage{
counting_rule_holds(delta)
}
\arguments{
\item{delta}{an \code{m} x \code{r} matrix of \code{0}s and \code{1}s, where \code{delta(i,j) == 1} if and only if
the i-th observation loads on the j-th factor}
}
\value{
\code{TRUE} if CR(\code{r},\code{1}) holds, \code{FALSE} otherwise
}
\description{
This is an implementation of the algorithm described in Section 3 of
Hosszejni and Fruehwirth-Schnatter (2026). The algorithm is used to verify
that the counting rule CR(r,1) holds for the sparsity pattern of the transpose
of a factor loading matrix. As detailed in Section 2 of the same paper, if
CR(r,1) holds, then the idiosyncratic variances are generically identified.
If CR(r,1) does not hold, then we do not know whether the idiosyncratic
variances are identified or not.
}
\examples{
# Two example matrices
cr_holds <-
  matrix(c(1, 0, 0,
           1, 0, 1,
           0, 1, 0,
           0, 1, 1,
           0, 1, 1,
           1, 1, 1,
           1, 1, 1),
         7, 3, byrow = TRUE)

cr_does_not_hold <-
  matrix(c(1, 0, 0,
           0, 0, 1,
           0, 1, 0,
           0, 1, 0,
           0, 1, 0,
           1, 1, 1,
           1, 1, 1),
         7, 3, byrow = TRUE)

# Check if the counting rule holds
counting_rule_holds(cr_holds)
#> [1] TRUE
counting_rule_holds(cr_does_not_hold)
#> [1] FALSE
}
\references{
Hosszejni and Fruehwirth-Schnatter (2026). "Cover It Up! Bipartite
Graphs Uncover Identifiability in Sparse Factor Analysis". Journal of
Multivariate Analysis, 211, 105536. ISSN 0047-259X.
\url{doi:10.1016/j.jmva.2025.105536}
}
\seealso{
\code{\link[stats:factanal]{stats::factanal()}}
}
\concept{factor analysis variance identification}
\keyword{models}
\keyword{multivariate}
