% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen-package.R
\docType{package}
\name{soundgen-package}
\alias{soundgen-package}
\title{The soundgen package}
\description{
Performs parametric synthesis of sounds with harmonic and noise components
such as animal vocalizations or human voice. Also offers tools for audio
manipulation and acoustic analysis, including pitch tracking, spectral
analysis, audio segmentation, pitch and formant shifting, etc. Includes four
interactive web apps for synthesizing and annotating audio, manually
correcting pitch contours, and measuring formant frequencies.
}
\details{
Visualization \itemize{
  \item \link{spectrogram} Ordinary (STFT) spectrograms
  \item \link{audSpectrogram} Auditory spectrograms
  \item \link{modulationSpectrum} Modulation spectra and roughness (see Anikin 2025)
  \item \link{ssm} Self-similarity matrices, acoustic novelty (see Anikin 2026)
  \item \link{phasegram} Nonlinear analysis, phasegrams (see Anikin & Herbst 2025)
}
Acoustic analysis \itemize{
  \item \link{analyze} General-purpose acoustic analysis (extracts nearly
  everything: spectral descriptives, pitch, formants, loudness, roughness,
  ...)
  \item \link{segment} Audio segmentation, analysis of rhythm and temporal
  structure of sequences
  \item \link{getSurprisal} Shannon and autocorrelation-based surprisal,
  Bayesian surprise (see Anikin 2026)
  \item \link{estimateVTL}, \link{schwa} Formant analysis (see Anikin et al. 2024)
}
Interactive acoustic analysis \itemize{
  \item \link{pitch_app} Manually corrected pitch tracking
  \item \link{formant_app} Manually corrected pitch tracking
  \item \link{annotation_app} Audio annotation
}
Sound synthesis \itemize{
  \item \link{soundgen} The main function for sound and voice synthesis (see Anikin 2019)
  \item \link{soundgen_app} Interaction version of the soundgen() function
  \item \link{morph} Morphing of two sounds based on their soundgen code
}
Sound modification \itemize{
  \item \link{normalizeFolder} Peak / RMS etc normalization of recordings
  \item \link{timeStretch}, \link{shiftPitch}, \link{prosody},
  \link{shiftFormants} Selective modification of fundamental frequency,
  duration, and/or resonance frequency
  \item \link{noiseRemoval}, \link{compressor}, \link{addAM}, \link{resample},
  etc: various audio effects
}

Vignettes \itemize{
  \item https://cogsci.se/soundgen/spectrograms.html
  \item https://cogsci.se/soundgen/sound_generation.html
  \item https://cogsci.se/soundgen/acoustic_analysis.html
  \item https://cogsci.se/soundgen/matching/matching.html
}
}
\references{
\itemize{
  \item Anikin, A. (2019). Soundgen: an open-source tool for synthesizing
  nonverbal vocalizations. Behavior Research Methods, 51(2), 778-792.
  \item Anikin, A., Barreda, S. & Reby, D. (2024) A practical guide to
  calculating vocal tract length and scale-invariant formant patterns.
  Behavior Research Methods 56, 5588–5604.
  \item Anikin, A. (2025) Acoustic estimation of voice roughness. Attention,
  Perception, & Psychophysics 87: 1771–1787.
  \item Anikin, A. & Herbst, C.T. (2025) How to analyze and manipulate
  nonlinear phenomena in voice recordings. Philosophical Transactions B 380:
  20240003.
  \item Anikin. A. (2026) Measuring surprisal in sound sequences.
  https://cogsci.se/publications/pdf/anikin_2026_surprisal_preprint.pdf
}
}
\seealso{
Useful links:
\itemize{
  \item \url{http://cogsci.se/soundgen.html}
}

}
\author{
\strong{Maintainer}: Andrey Anikin \email{andrey.anikin@cogsci.se}

}
\keyword{internal}
