% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSounds.R
\name{getMelSpec}
\alias{getMelSpec}
\title{Mel-transformed spectrogram}
\usage{
getMelSpec(
  s,
  samplingRate = NULL,
  windowLength = 40,
  overlap = 50,
  step = NULL,
  dynamicRange = 80,
  maxFreq = NULL,
  specPars = list(),
  plot = FALSE
)
}
\arguments{
\item{s}{input sound (path to a .wav file or numeric vector)}

\item{samplingRate}{if one or both inputs are numeric vectors, specify
sampling rate, Hz. A vector of length 2 means the two inputs have different
sampling rates, in which case spectrograms are compared only up to the
lower Nyquist frequency}

\item{windowLength}{length of FFT window, ms (multiple values in a vector
produce a multi-resolution spectrogram)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{step}{you can override \code{overlap} by specifying FFT step, ms - a
vector of the same length as windowLength (NB: because digital audio is
sampled at discrete time intervals of 1/samplingRate, the actual step and
thus the time stamps of STFT frames may be slightly different, eg 24.98866
instead of 25.0 ms)}

\item{dynamicRange}{parts of the spectra quieter than \code{-dynamicRange} dB
are not compared}

\item{maxFreq}{parts of the spectra above \code{maxFreq} Hz are not compared}

\item{specPars}{a list of parameters passed to \code{\link[tuneR]{melfcc}}}

\item{plot}{if TRUE, plots the spectrum}
}
\description{
Internal soundgen function
}
\details{
Takes a .wav file or a waveform as numeric vector + samplingRate and returns
mel-transformed spectrum (auditory spectrum). Calls
\code{\link[tuneR]{melfcc}}. See \code{\link{compareSounds}}.
}
\keyword{internal}
