% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{generateGC}
\alias{generateGC}
\title{Generate glottal cycles}
\usage{
generateGC(
  pitch_per_gc,
  glottisClosed_per_gc,
  rolloff_per_gc,
  samplingRate,
  interpol = "approx"
)
}
\arguments{
\item{pitch_per_gc}{pitch per glottal cycle, Hz}

\item{glottisClosed_per_gc}{proportion of closed phase per glottal cycle, \%}

\item{rolloff_per_gc}{a list of one-column matrices, one for each glottal
cycle, specifying rolloff per harmonic (linear multiplier, ie NOT in dB)
Each matrix has as many rows as there are harmonics, and rownames specify
the ratio to F0 (eg 1.5 means it's a subharmonic added between f0 and its
first harmonic)}

\item{samplingRate}{the sampling rate of generated sound, Hz}

\item{interpol}{method used to adjust the number of gc to target duration}
}
\value{
Returns a waveform as a non-normalized numeric vector centered at
  zero.
}
\description{
Internal soundgen function. Takes descriptives of a number of glottal cycles
(f0, closed phase, rolloff - note that all three should be vectors of the
same length, namely nGC) and creates a waveform consisting of a string of
these glottal cycles separated by pauses (if there is a closed phase). The
principle is to work with one glottal cycle at a time and create a sine wave
for each harmonic, with amplitudes adjusted by rolloff.
}
\examples{
pitch_per_gc = seq(100, 150, length.out = 25)
glottisClosed_per_gc = seq(0, 300, length.out = 25)
m = matrix(10 ^ (-6 * log2(1:200) / 20))
rownames(m) = 1:nrow(m)
rolloff_per_gc = rep(list(m), 25)
s = soundgen:::generateGC(pitch_per_gc, glottisClosed_per_gc,
                          rolloff_per_gc, samplingRate = 16000)
# plot(s, type = 'l')
# playme(s)
}
\keyword{internal}
