% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmdscale.R
\name{cmdscale}
\alias{cmdscale}
\title{Wrapper to \code{cmdscale} for S3 class}
\usage{
cmdscale(d, k = 2, eig = FALSE, ...)
}
\arguments{
\item{d}{a distance structure such as that returned by 'dist' or a full symmetric matrix containing the dissimilarities}

\item{k}{the maximum dimension of the space which the data are to be represented in}

\item{eig}{indicates whether eigenvalues should be returned. Defaults to TRUE.}

\item{...}{additional parameters passed to cmdscale. See \code{\link{cmdscale}}}
}
\value{
Object of class 'cmdscalex' and 'cmdscale' extending \code{\link{cmdscale}}. This wrapper always returns the results of cmdscale as a list, adds column labels to the $points and adds extra elements (conf=points, delta=d, confdist=dist(conf), dhat=d) and the call to the list, and assigns S3 class 'cmdscalex' and 'cmdscale'.
}
\description{
Wrapper to \code{cmdscale} for S3 class
}
\details{
overloads stats::cmdscale turns on the liosting and adds slots and class attributes for which there are methods.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
res<-cmdscale(dis)
}
