% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slcm-wrapper.R
\name{slcm}
\alias{slcm}
\title{Sparse Latent Class Model for Cognitive Diagnosis (SLCM)}
\usage{
slcm(
  y,
  k,
  burnin = 1000L,
  chain_length = 10000L,
  psi_invj = c(1, rep(2, 2^k - 1)),
  m0 = 0,
  bq = 1
)
}
\arguments{
\item{y}{Item Matrix}

\item{k}{Dimension to estimate for Q matrix}

\item{burnin}{Amount of Draws to Burn}

\item{chain_length}{Number of Iterations for chain.}

\item{psi_invj, m0, bq}{Additional tuning parameters.}
}
\value{
An \code{slcm} object containing three named lists:
\itemize{
\item \strong{\code{estimates}}
\itemize{
\item \code{beta}: Average beta coefficients
\item \code{theta}: Average theta coefficients
\item \code{delta}: Average activeness of coefficients
\item \code{class}: Average class membership
\item \code{pi}: Average attribute class probability.
\item \code{omega}: Average omega
\item \code{q}: Average activeness of Q matrix entries based on heuristic transformation.
\item \code{m2ll}: Average negative two times log-likelihood
}
\item \strong{\code{chain}}
\itemize{
\item \code{theta}: theta coefficients iterations
\item \code{beta}:  beta coefficients iterations
\item \code{class}:  class membership iterations
\item \code{pi}:  attribute class probability iterations
\item \code{omega}:  omega iterations
\item \code{m2ll}: Negative two times log-likelihood iterations
}
\item \strong{\code{details}}
\itemize{
\item \code{n}: Number of Subjects
\item \code{j}: Number of Items
\item \code{k}: Number of Traits
\item \code{l1}: Slab parameter
\item \code{m0}, \code{bq}: Additional tuning parameters
\item \code{burnin}: Number of Iterations to discard
\item \code{chain_length}: Number of Iterations to keep
\item \code{runtime}: Duration of model run inside of the C++ code. (Does not include summarization of MCMC chain.)
\item \code{package_version}: Version of the package the SLCM model was fit with.
\item \code{date_time}: Date and Time the model was fit.
}
}
}
\description{
Performs the Gibbs sampling routine for a sparse latent class model
as described in Chen et al. (2020) <doi: 10.1007/s11336-019-09693-2>
}
\details{
The \strong{\code{estimates}} list contains the mean information from the sampling
procedure. Meanwhile, the \strong{\code{chain}} list contains full MCMC values. Lastly,
the \strong{\code{details}} list provides information regarding the estimation call.
}
\examples{
# Load Namespace
naming = requireNamespace("edmdata", quietly = TRUE)

# Use a demo data set from the paper
data("items_matrix_reasoning", package = "edmdata")
  
burnin = 50        # Set for demonstration purposes, increase to at least 1,000 in practice.
chain_length = 100 # Set for demonstration purposes, increase to at least 10,000 in practice.  
  
model_reasoning = slcm(edmdata::items_matrix_reasoning, k = 4, 
                       burnin = burnin, chain_length = chain_length)
                         
print(model_reasoning)
}
