% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{sampleStep}
\alias{sampleStep}
\title{Perform a single step of the MCMC sampling process for skipTrack}
\usage{
sampleStep(
  ijDat,
  iDat,
  rho,
  pi,
  X,
  Z,
  Beta,
  Gamma,
  priorAlphas,
  indFirst,
  rhoBeta,
  rhoGamma,
  phi,
  rhoPhi,
  fixedSkips
)
}
\arguments{
\item{ijDat}{A data.frame with individual-observation level parameters: Individual, ys, cijs, muis, tauis.}

\item{iDat}{A data.frame with individual level parameters: Individual, mus, taus, thetas.}

\item{rho}{Updated value of the global parameter rho.}

\item{pi}{Updated value of the global parameter pi.}

\item{X}{A matrix (numIndividuals x length(Beta)) of covariates for cycle length mean. Default is a vector of 1's. NOTE THE DIFFERENCE (from skipTrack.MCMC) IN EXPECTED DIMENSION OF X}

\item{Z}{A matrix (numIndividuals x length(Gamma)) of covariates for cycle length precision. Default is a vector of 1's. NOTE THE DIFFERENCE (from skipTrack.MCMC) IN EXPECTED DIMENSION OF Z}

\item{Beta}{Matrix (1 x length(Beta)) of coefficients for cycle length mean.}

\item{Gamma}{Matrix of (1 x length(Gamma)) coefficients for cycle length precision.}

\item{priorAlphas}{Vector of prior alpha values for updating pi.}

\item{indFirst}{A logical vector indicating the first occurrence of each individual.}

\item{rhoBeta}{Updated value of the global parameter rhoBeta.}

\item{rhoGamma}{Value of the proposal parameter rhoGamma.}

\item{phi}{Value of the parameter phi.}

\item{rhoPhi}{Value of the proposal parameter rhoPhi.}

\item{fixedSkips}{Logical. If TRUE cycle skip information (cijs) is not updated in sample steps and the inputs are instead assumed to be true.}
}
\value{
A list containing updated parameters after performing a single MCMC step.
The list includes:
\describe{
\item{ijDat}{A data.frame with updated parameters at the individual-observation level: Individual, ys, cijs, muis, tauis.}
\item{iDat}{A data.frame with updated parameters at the individual level: Individual, mus, taus, thetas.}
\item{rho}{Updated value of the global parameter rho.}
\item{pi}{Updated value of the global parameter pi.}
\item{X}{Matrix of covariates for cycle length mean.}
\item{Z}{Matrix of covariates for cycle length precision.}
\item{Beta}{Updated matrix of coefficients for cycle length mean.}
\item{Gamma}{Updated matrix of coefficients for cycle length precision.}
\item{priorAlphas}{Vector of prior alpha values for updating pi.}
\item{indFirst}{A logical vector indicating the first occurrence of each individual.}
\item{rhoBeta}{Hyperprior parameter rhoBeta, used to update Beta.}
\item{rhoGamma}{Value of the proposal parameter rhoGamma.}
\item{phi}{Updated value of the parameter phi.}
\item{rhoPhi}{Value of the proposal parameter rhoPhi.}
\item{fixedSkips}{Logical. Indicates if skips were fixed.}
}
}
\description{
This function performs a single step of the Markov Chain Monte Carlo (MCMC) algorithm to update parameters
in a hierarchical model used for identifying skips in menstrual cycle tracking.
}
