% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_templates.R
\name{check_sitrep_templates}
\alias{check_sitrep_templates}
\title{Run the templates found in the sitrep package.}
\usage{
check_sitrep_templates(
  templates = available_sitrep_templates(),
  path = tempdir(),
  quiet = FALSE,
  progress = FALSE,
  mustwork = FALSE,
  output_format = NULL,
  clean = TRUE
)
}
\arguments{
\item{templates}{a vector of templates to create and render}

\item{path}{a directory in which to store the templates}

\item{quiet}{if \code{FALSE} (default), a message will be printed for every
template.}

\item{progress}{if \code{TRUE}, then the progress of the template is printed
to screen (passed to the \code{quiet} argument of \code{\link[rmarkdown:render]{rmarkdown::render()}}).
Defaults to \code{FALSE}}

\item{mustwork}{if \code{TRUE}, then the templates must work for the function to
succeed. Defaults to \code{FALSE}, which will simply print the errors.}

\item{output_format}{a character defining the output formats to use for the
template files. Defaults to the output_format defined in the templates
(which is \code{word_document}), but can be modified to \code{html_document} for
cross-platform cromulence checking.}

\item{clean}{if \code{TRUE} (default), this will remove the previous output file
before rendering.}
}
\value{
the path where the templates were built.
}
\description{
Run the templates found in the sitrep package.
}
\examples{
\donttest{
check_sitrep_templates("mortality")
}
}
