% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-biomass.R
\name{eq_biomass_dieguez_aranda_2009}
\alias{eq_biomass_dieguez_aranda_2009}
\title{Biomass equations for Galician species}
\usage{
eq_biomass_dieguez_aranda_2009(
  species,
  component = "stem",
  return_r2 = FALSE,
  return_rmse = FALSE
)
}
\arguments{
\item{species}{A character string specifying the scientific name of the tree
species. It can be a column name if all the species are included in this model.
See Details for available species.}

\item{component}{A character string specifying the tree component for biomass
calculation (e.g., "tree", "stem", "branches"). See Details.}

\item{return_r2}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}

\item{return_rmse}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}
}
\value{
A S7 list of parameters
}
\description{
Allometric equations adjusted for Galician (Spain) species
}
\details{
There are seven species included in this model: \emph{Pinus pinaster, Pinaster radiata, Pinus}
\emph{sylvestris, Eucalyptus globulus, Eucalyptus nitens, Quercus robur}, and \emph{Betula alba}

The tree components are divided into groups, and any of them can be introduced in the
component argument:
\itemize{
\item \strong{AGB}: all aboveground biomass components
\item \strong{BGB}: all belowground biomass compoponents
\item \strong{tree}: total tree biomass includying AGB and BGB
}

Then we have the second group of components, which are related to tree groups:
\itemize{
\item \strong{stem}: includes the stem and bark
\item \strong{branches}: includes all branches
\item \strong{roots}: includes the roots (same as BGB)
}

Finally, we have the last level, which includes tree components (not all of them
are available for all species): stem, bark, thick branches (>7cm), medium branches (2-7cm),
thin branches (0.5-2cm), twigs (<0.5cm), dry branches, leaves, roots. In some species,
there's "stem and thick branches", instead of two groups.

Users can check the list of supported species and their corresponding components
in \link{biomass_models}.
}
\examples{
## get model parameters for silv_predict_biomass
eq_biomass_dieguez_aranda_2009("Pinus pinaster", "AGB")
}
\seealso{
\code{\link[=silv_predict_biomass]{silv_predict_biomass()}}, \link{biomass_models}, \code{\link[=eq_biomass_montero_2005]{eq_biomass_montero_2005()}},
\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}, \code{\link[=eq_biomass_ruiz_peinado_2012]{eq_biomass_ruiz_peinado_2012()}}, \code{\link[=eq_biomass_manrique_2017]{eq_biomass_manrique_2017()}},
\code{\link[=eq_biomass_menendez_2022]{eq_biomass_menendez_2022()}}, \code{\link[=eq_biomass_cudjoe_2024]{eq_biomass_cudjoe_2024()}}
}
