% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_user_f.R
\name{select_user}
\alias{select_user}
\title{Load a raster image}
\usage{
select_user(raster_path, logger = NULL)
}
\arguments{
\item{raster_path}{character. Path to file to be loaded}

\item{logger}{Stores all notification messages to be displayed in the Log
Window. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL}
}
\value{
a SpatRaster object
}
\description{
Called by the select_user module in the example app and loads a
.tif file as a SpatRaster
}
\examples{
if (check_suggests(example = TRUE)) {
  raster_path <- list.files(system.file("extdata", "wc", package = "shinyscholar"),
  full.names = TRUE)
  raster <- select_user(raster_path)
} else {
  message('reinstall with install.packages("shinyscholar", dependencies = TRUE)
  to run this example')
}
}
\author{
Simon Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
