% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley.plot.R
\name{shapley.plot}
\alias{shapley.plot}
\title{Plot weighted SHAP contributions}
\usage{
shapley.plot(
  shapley,
  plot = "bar",
  method = "mean",
  cutoff = 0.01,
  top_n_features = NULL,
  features = NULL,
  legendstyle = "continuous",
  scale_colour_gradient = NULL
)
}
\arguments{
\item{shapley}{object of class 'shapley', as returned by the 'shapley' function}

\item{plot}{character, specifying the type of the plot, which can be either
'bar', 'waffle', or 'shap'. The default is 'bar'.}

\item{method}{Character. The column name in \code{summaryShaps} used
for feature selection. Default is \code{"mean"}, which
selects important features which have weighted mean shap
ratio (WMSHAP) higher than the specified cutoff. Other
alternative is "lowerCI", which selects features which
their lower bound of confidence interval is higher than
the cutoff.}

\item{cutoff}{numeric, specifying the cutoff for the method used for selecting
the top features.}

\item{top_n_features}{Integer. If specified, the top n features with the
highest weighted SHAP values will be selected, overrullung
the 'cutoff' and 'method' arguments.}

\item{features}{character vector, specifying the feature to be plotted.}

\item{legendstyle}{character, specifying the style of the plot legend, which
can be either 'continuous' (default) or 'discrete'. the
continuous legend is only applicable to 'shap' plots and
other plots only use 'discrete' legend.}

\item{scale_colour_gradient}{character vector for specifying the color gradients
for the plot.}
}
\value{
ggplot object
}
\description{
This function applies different criteria to visualize SHAP contributions
}
\examples{

\dontrun{
# load the required libraries for building the base-learners and the ensemble models
library(h2o)            #shapley supports h2o models
library(shapley)

# initiate the h2o server
h2o.init(ignore_config = TRUE, nthreads = 2, bind_to_localhost = FALSE, insecure = TRUE)

# upload data to h2o cloud
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)

### H2O provides 2 types of grid search for tuning the models, which are
### AutoML and Grid. Below, I demonstrate how weighted mean shapley values
### can be computed for both types.

set.seed(10)

#######################################################
### PREPARE AutoML Grid (takes a couple of minutes)
#######################################################
# run AutoML to tune various models (GBM) for 60 seconds
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 120,
                 include_algos=c("GBM"),

                 # this setting ensures the models are comparable for building a meta learner
                 seed = 2023, nfolds = 10,
                 keep_cross_validation_predictions = TRUE)

### call 'shapley' function to compute the weighted mean and weighted confidence intervals
### of SHAP values across all trained models.
### Note that the 'newdata' should be the testing dataset!
result <- shapley(models = aml, newdata = prostate, plot = TRUE)

#######################################################
### PLOT THE WEIGHTED MEAN SHAP VALUES
#######################################################

shapley.plot(result, plot = "bar")
}
}
\author{
E. F. Haghish
}
