% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_matrix_display.R
\name{sfcr_matrix_display}
\alias{sfcr_matrix_display}
\title{Print matrix to screen}
\usage{
sfcr_matrix_display(matrix, which = "tfm")
}
\arguments{
\item{matrix}{A balance sheet or transactions-flow matrix}

\item{which}{A character string for the matrix. Is it a balance-sheet or
a transactions-flow matrix? here are two options:
\code{"bs"} for balance-sheet matrices, and \code{"tfm"} for transactions-
flow matrices. The default is \code{"tfm"}.}
}
\description{
Print matrix to screen
}
\details{
This function takes a matrix as input and generate a \code{kableExtra}
table with math symbols displayed in latex style.
}
\note{
This function converts the math expressions used to build the \code{sfcr_matrix}
into a latex format, but cannot add modifications to it. The user is
invited to explore the source code and the \code{kableExtra} package in order to
personalize his/her own matrices.
}
\examples{
# Balance-sheet matrix

bs_insout <- sfcr_matrix(
  columns = c("Households", "Firms", "Government", "Central bank", "Banks", "Sum"),
  codes = c("h", "f", "g", "cb", "b", "s"),
  r1 = c("Inventories", f = "+INV", s = "+INV"),
  r2 = c("HPM", h = "+Hhd", cb = "-Hs", b = "+Hbd"),
  r3 = c("Advances", cb = "+As", b = "-Ad"),
  r4 = c("Checking deposits", h = "+M1h", b = "-M1s"),
  r5 = c("Time deposits", h = "+M2h", b = "-M2s"),
  r6 = c("Bills", h = "+Bhh", g = "-Bs", cb = "+Bcb", b = "+Bbd"),
  r7 = c("Bonds", h = "+BLh * pbl", g = "-BLs * pbl"),
  r8 = c("Loans", f = "-Ld", b = "+Ls"),
  r9 = c("Balance", h = "-V", f = 0, g = "+GD", cb = 0, b = 0, s = "-INV")
)

sfcr_matrix_display(bs_insout, "bs")
}
\author{
João Macalós
}
