% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_expand.R
\name{sfcr_expand}
\alias{sfcr_expand}
\title{Expand variables to implement sensitivity analysis}
\usage{
sfcr_expand(x, variable, values)
}
\arguments{
\item{x}{A external set created with \code{sfcr_set()} or
a shock set created with \code{sfcr_shock()}}

\item{variable}{the name of variable to be expanded.}

\item{values}{a vector containing the new values of the external or
shock variable.}
}
\description{
The \code{sfcr_expand()} function is a s3 \strong{generic} that takes
a list of external objects and returns a expanded set of these lists.
It has methods for \code{sfcr_set} objects and for \code{sfcr_shock} objects.
}
\details{
There are two available methods for the \code{sfcr_expand()} function:
\itemize{
\item \code{sfcr_set}:
Takes a \code{sfcr_set} object with \strong{external} variables and creates
a list of sets that inherits all the aspects of the \code{x} set supplied
but set the values of the \code{variable} to the each element of \code{value}.
The output is a \code{sfcr_mlt_set} object.
\item \code{sfcr_shock}:
Takes a \code{sfcr_shock} object and creates a list of shocks that inherits
all the aspects of the \code{x} shock but set the \code{values} of the
\code{variable} to each element of \code{value}. The output of this
method is a \code{sfcr_mlt_shock} object.
}
}
\examples{
# 1. Expand a external set:
external <- sfcr_set(G_d ~ 20, W ~ 1, alpha1 ~ 0.6, alpha2 ~ 0.4, theta ~ 0.2)
sfcr_expand(external, alpha2, c(0.1, 0.2))

# 2. Expand a shock:
shock <- sfcr_shock(variables = sfcr_set(alpha1 ~ 0.8), start = 5, end = 50)
sfcr_expand(shock, alpha1, c(0.7, 0.8, 0.9))

}
\author{
João Macalós
}
