% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{mod_infinitable}
\alias{mod_infinitable}
\title{Ignore infinite values in a predicate}
\usage{
mod_infinitable(pred)
}
\arguments{
\item{pred}{A predicate function}
}
\value{
A new predicate that ignores infinites
}
\description{
This modifies a predicate function to ignore Inf.
}
\examples{
# The `is_incrementing` predicate will fail here
x <- c(1, Inf, 3)
is_incrementing(x) # FALSE

is_incrementing_inf <- mod_infinitable(is_incrementing)
is_incrementing_inf(x) # TRUE
}
