% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{scMetaTraj_trend}
\alias{scMetaTraj_trend}
\title{Compute metabolic module trend along pseudotime}
\usage{
scMetaTraj_trend(scores, mPT, n_bins = 30, smooth = TRUE, span = 0.3)
}
\arguments{
\item{scores}{Numeric vector of module scores (length = n_cells).}

\item{mPT}{Numeric vector of metabolic pseudotime values (length = n_cells).}

\item{n_bins}{Integer. Number of bins along mPT for trend computation.}

\item{smooth}{Logical. Whether to apply loess smoothing to the binned trend.}

\item{span}{Numeric. Loess span parameter (only used if smooth = TRUE).}
}
\value{
A data frame with columns:
\item{mPT_bin}{Mid-point of each mPT bin}
\item{score}{Mean score per bin}
\item{score_smooth}{Smoothed score (if smooth = TRUE, otherwise same as score)}
}
\description{
Bins cells along metabolic pseudotime (mPT) and computes mean module
scores per bin, with optional loess smoothing.
}
\examples{
# Create example data
set.seed(123)
n_cells <- 200
mPT <- runif(n_cells, 0, 1)
scores <- sin(mPT * 2 * pi) + rnorm(n_cells, 0, 0.1)

# Compute trend
trend <- scMetaTraj_trend(
  scores = scores,
  mPT = mPT,
  n_bins = 30,
  smooth = TRUE,
  span = 0.3
)

# Plot trend
plot(trend$mPT_bin, trend$score_smooth, type = "l",
     xlab = "Metabolic pseudotime", ylab = "Module score")

}
