% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities_Objects.R
\name{Random_Cells_Downsample}
\alias{Random_Cells_Downsample}
\title{Randomly downsample by identity}
\usage{
Random_Cells_Downsample(
  seurat_object,
  num_cells,
  group.by = NULL,
  return_list = FALSE,
  allow_lower = FALSE,
  entire_object = FALSE,
  seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object}

\item{num_cells}{number of cells per ident to use in down-sampling.  This value must be less than or
equal to the size of ident with fewest cells.  Alternatively, can set to "min" which will
use the maximum number of barcodes based on size of smallest group.}

\item{group.by}{The ident to use to group cells.  Default is NULL which use current active.ident.  .}

\item{return_list}{logical, whether or not to return the results as list instead of vector, default is
FALSE.}

\item{allow_lower}{logical, if number of cells in identity is lower than \code{num_cells} keep the
maximum number of cells, default is FALSE.  If FALSE will report error message if \code{num_cells} is
too high, if TRUE will subset cells with more than \code{num_cells} to that value and those with less
than \code{num_cells} will not be downsampled.}

\item{entire_object}{logical, whether to downsample to specific number of cells across whole object,
instead of number of cells per identity, default is FALSE.}

\item{seed}{random seed to use for downsampling.  Default is 123.}
}
\value{
either a vector or list of cell barcodes
}
\description{
Get a randomly downsampled set of cell barcodes with even numbers of cells for each identity class.
Can return either as a list (1 entry per identity class) or vector of barcodes.
}
\examples{
library(Seurat)

# return vector of barcodes
random_cells <- Random_Cells_Downsample(seurat_object = pbmc_small, num_cells = 10)
head(random_cells)

# return list
random_cells_list <- Random_Cells_Downsample(seurat_object = pbmc_small, return_list = TRUE,
num_cells = 10)
head(random_cells_list)

# return max total number of cells (setting `num_cells = "min`)
random_cells_max <- Random_Cells_Downsample(seurat_object = pbmc_small, num_cells = "min")

}
\concept{get_set_util}
