% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat.R
\name{FeatureScatter_scCustom}
\alias{FeatureScatter_scCustom}
\title{Modified version of FeatureScatter}
\usage{
FeatureScatter_scCustom(
  seurat_object,
  feature1 = NULL,
  feature2 = NULL,
  cells = NULL,
  colors_use = NULL,
  pt.size = NULL,
  group.by = NULL,
  split.by = NULL,
  split_seurat = FALSE,
  shuffle = TRUE,
  aspect_ratio = NULL,
  title_size = 15,
  plot.cor = TRUE,
  num_columns = NULL,
  raster = NULL,
  raster.dpi = c(512, 512),
  ggplot_default_colors = FALSE,
  color_seed = 123,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{feature1}{First feature to plot.}

\item{feature2}{Second feature to plot.}

\item{cells}{Cells to include on the scatter plot.}

\item{colors_use}{color for the points on plot.}

\item{pt.size}{Adjust point size for plotting.}

\item{group.by}{Name of one or more metadata columns to group (color) cells by (for example, orig.ident).
Default is active ident.}

\item{split.by}{Feature to split plots by (i.e. "orig.ident").}

\item{split_seurat}{logical.  Whether or not to display split plots like Seurat (shared y axis) or as
individual plots in layout.  Default is FALSE.}

\item{shuffle}{logical, whether to randomly shuffle the order of points. This can be useful for crowded plots if points of interest are being buried. Default is TRUE.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{title_size}{size for plot title labels. Does NOT apply if \code{split_seurat = TRUE}.}

\item{plot.cor}{Display correlation in plot subtitle (or title if \code{split_seurat = TRUE}).}

\item{num_columns}{number of columns in final layout plot.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{FeatureScatter}}.}
}
\value{
A ggplot object
}
\description{
Create customized FeatureScatter plots with scCustomize defaults.
}
\examples{
\donttest{
library(Seurat)

pbmc_small$sample_id <- sample(c("sample1", "sample2"), size = ncol(pbmc_small), replace = TRUE)

FeatureScatter_scCustom(seurat_object = pbmc_small, feature1 = "nCount_RNA",
feature2 = "nFeature_RNA", split.by = "sample_id")
}

}
\concept{seurat_plotting}
