% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skip-run.R
\name{skip_run_if}
\alias{skip_run_if}
\title{Skip code}
\usage{
skip_run_if(code, cond = NULL, files = NULL, timing = TRUE)
}
\arguments{
\item{code}{Code to run. Do not forget to wrap it with \code{{ }}.}

\item{cond}{Condition to be fulfilled to skip running \code{code}.
Default is \code{NULL} (not used).
Should evaluate to either \code{TRUE} or \code{FALSE} otherwise.}

\item{files}{Character vector of file path(s). Default is \code{NULL} (not used).
This function checks if all these files exist, and if they all do exist,
it skips running \code{code}.}

\item{timing}{Whether to print timing of running code? Default is \code{TRUE}.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Skip code if all conditions are fulfilled.
The code should not return anything.
}
\examples{
# Prepare some temporary file
tmp <- tempfile(fileext = ".txt")

# Run once because file does not exist yet
skip_run_if({
  Sys.sleep(2)
  write.table(iris, tmp)
}, cond = file.exists(tmp))

# Skip run because `cond` is `TRUE`
skip_run_if({
  Sys.sleep(2)
  write.table(iris, tmp)
}, cond = file.exists(tmp))

# Skip run because file exists
skip_run_if({
  Sys.sleep(2)
  write.table(iris, tmp)
}, files = tmp)

}
