% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disaggregate.R
\name{disaggregate_positive}
\alias{disaggregate_positive}
\title{Disaggregation function for strictly positive covariates}
\usage{
disaggregate_positive(
  W,
  y_r,
  pop,
  adj,
  lambda_smooth = 1,
  lambda_entropy = 0,
  weights = NULL
)
}
\arguments{
\item{W}{m x n aggregation matrix}

\item{y_r}{length m vector (observed regional counts)}

\item{pop}{length n vector (population per cell)}

\item{adj}{n x n adjacency matrix (1 if neighbours, 0 otherwise)
or a sparse Matrix from the Matrix package}

\item{lambda_smooth}{weight on spatial smoothness}

\item{lambda_entropy}{weight on entropy (0 = pure QP, >0 = nonlinear)}

\item{weights}{optional n x n matrix of edge weights (e.g., inverse distance)}
}
\value{
A list
}
\description{
Pycnophylactic disaggregation with spatial smoothness on rates
}
\details{
Solves: min ||W y_s - y_r||^2
+ lambda_smooth * sum_(i~j) w_ij (r_i - r_j)^2
+ lambda_entropy * sum(y_s * log(y_s))
s.t. y_s >= 0
}
