% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Means_DDCt.r
\name{Means_DDCt}
\alias{Means_DDCt}
\title{Relative expression (\eqn{\Delta \Delta C_T}) analysis using a fitted model}
\usage{
Means_DDCt(model, specs, p.adj = "none")
}
\arguments{
\item{model}{A fitted model object (typically an \code{lmer} or \code{lm} object)
created by \code{ANOVA_DDCt()} or \code{REPEATED_DDCt()}.}

\item{specs}{A character string or character vector specifying the predictors or
combinations of predictors over which fold change values are desired.
This argument follows the specification syntax used by
\code{emmeans::emmeans()} (e.g., \code{"Factor"},
\code{"Factor1 | Factor2"}).}

\item{p.adj}{Character string specifying the method for adjusting p-values.
See \code{\link[stats]{p.adjust}} for available options.}
}
\value{
A data frame containing estimated fold change values, confidence
intervals, p-values, and significance levels derived from the fitted
model.
}
\description{
Performs relative expression (fold change) analysis based on the
\eqn{\Delta \Delta C_T} method using a fitted model object produced by
\code{ANOVA_DDCt()} or \code{REPEATED_DDCt()}.
}
\details{
The \code{Means_DDCt} function calculates fold change (FC) values using
estimated marginal means derived from a fitted model.
For ANOVA models, FC values can be obtained for main effects,
interactions, and sliced (simple) effects.
For ANCOVA models returned by the \pkg{rtpcr} package, only simple
effects are supported.

Internally, this function relies on the \pkg{emmeans} package to
compute marginal means and contrasts, which are then back-transformed
to fold change values using the \eqn{\Delta \Delta C_T} framework.
}
\examples{

# Obtain a fitted model from ANOVA_DDCt
res <- ANOVA_DDCt(
  data_3factor,
  numberOfrefGenes = 1,
  mainFactor.column = 1,
  block = NULL
)

# Fold change values for Type main effect
Means_DDCt(res$lm_ANOVA, specs = "Type")

# Fold change values for Concentration main effect
Means_DDCt(res$lm_ANOVA, specs = "Conc")

# Fold change values for Concentration sliced by Type
Means_DDCt(res$lm_ANOVA, specs = "Conc | Type")

# Fold change values for Concentration sliced by Type and SA
Means_DDCt(res$lm_ANOVA, specs = "Conc | Type * SA")
}
\author{
Ghader Mirzaghaderi
}
