% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_categories.R
\name{rl_green}
\alias{rl_green}
\alias{rl_green_}
\title{Green Status assessment summary}
\usage{
rl_green(key = NULL, parse = TRUE, ...)

rl_green_(key = NULL, ...)
}
\arguments{
\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{parse}{(logical) Whether to parse the output to list (\code{FALSE}) or,
where possible, data.frame (\code{TRUE}). Default: \code{TRUE}.}

\item{...}{Includes the following arguments related to the wait time between
request retries if a "Too Many Requests" error is received from the API
(see \link[crul:HttpClient]{HttpClient()$retry()} for more details):
\itemize{
\item \code{pause_base}, \code{pause_cap}, and \code{pause_min}: basis, maximum, and minimum
for calculating wait time for retry
\item \code{times}: the maximum number of times to retry
\item \code{onwait}: a callback function if the request will be retried and a
wait time is being applied
}
Also supports any \link[curl:curl_options]{curl options} passed to the GET
request via \link[crul:HttpClient]{HttpClient}.}
}
\value{
A list unless using a function with a trailing underscore, in which
case json as character string is returned.
}
\description{
List all Green Status assessments.
}
\examples{
\dontrun{
# Get list of Green Status assessments
rl_green()
}
}
\references{
API docs at \url{https://api.iucnredlist.org/}.
}
\seealso{
Assessments for specific sets of taxa
\code{\link{rl_comp_groups}()},
\code{\link{rl_extinct}()},
\code{\link{rl_extinct_wild}()},
\code{\link{rl_growth_forms}()}
}
\concept{groups}
