% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_secret_route.R
\name{shared_secret_route}
\alias{shared_secret_route}
\title{Reject requests not in possession of the correct shared secret}
\usage{
shared_secret_route(secret, header)
}
\arguments{
\item{secret}{The secret to check for in a request}

\item{header}{The name of the header to look for the secret}
}
\value{
A \link{Route} object
}
\description{
This route is a simple authentication method that limits requests based on
whether they are in possession of an agreed upon shared secret. Be aware that
if the request is send over HTTP then the secret will be visible to anyone
intercepting the request. For this reason you should only use this route in
combination with HTTPS or accept the probability that the secret is exposed.
If no shared secret is provided with the request \emph{or} if the shared secret
doesn't match a \verb{400L Bad Request} response is returned.
}
\seealso{
Other Route constructors: 
\code{\link{asset_route}()},
\code{\link{openapi_route}()},
\code{\link{resource_route}()},
\code{\link{sizelimit_route}()}
}
\concept{Route constructors}
