% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regarima_outliers.R
\name{regarima_outliers}
\alias{regarima_outliers}
\title{Outlier Detection with a RegARIMA Model}
\usage{
regarima_outliers(
  y,
  order = c(0L, 1L, 1L),
  seasonal = c(0L, 1L, 1L),
  mean = FALSE,
  X = NULL,
  X.td = NULL,
  ao = TRUE,
  ls = TRUE,
  tc = FALSE,
  so = FALSE,
  cv = 0,
  clean = FALSE
)
}
\arguments{
\item{y}{the dependent variable (a \code{ts} object).}

\item{order, seasonal}{the orders of the ARIMA model.}

\item{mean}{Boolean to include or not the mean.}

\item{X}{user defined regressors (other than calendar).}

\item{X.td}{calendar regressors.}

\item{ao, ls, so, tc}{Boolean to indicate which type of outliers should be
detected.}

\item{cv}{\code{numeric}. The entered critical value for the outlier detection
procedure. If equal to 0 the critical value for the outlier detection
procedure is automatically determined by the number of observations.}

\item{clean}{Clean missing values at the beginning/end of the series.
Regression variables are automatically resized, if need be.}
}
\value{
a \code{"JD3_REGARIMA_OUTLIERS"} object, containing input variables and results
}
\description{
Outlier Detection with a RegARIMA Model
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# estimate model
model <- regarima_outliers(rjd3toolkit::ABS$X0.2.09.10.M)
# print outliers
model$model$variables
\dontshow{\}) # examplesIf}
}
