% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{rxp_visnetwork}
\alias{rxp_visnetwork}
\title{Create a Directed Acyclic Graph (DAG) Representing the Pipeline
Using \code{{visNetwork}}}
\usage{
rxp_visnetwork(
  nodes_and_edges = get_nodes_edges(),
  color_by = c("pipeline", "type"),
  colour_by = NULL
)
}
\arguments{
\item{nodes_and_edges}{List, output of \code{get_nodes_edges()}.}

\item{color_by}{Character, either "pipeline" (default) or "type".
When "pipeline", nodes show type as fill colour and pipeline as border.
When "type", nodes are colored by their derivation type (rxp_r, rxp_py, etc.).}

\item{colour_by}{Character, alias for \code{color_by}.}
}
\value{
Nothing, this function opens a new tab in your browser with
the DAG generated using \code{{visNetwork}}.
}
\description{
Uses \code{{visNetwork}} to generate the plot. \code{{visNetwork}} is a
soft dependency of \code{{rixpress}} so you need to install it to use this
function. When derivations are organized into pipelines using
\code{rxp_pipeline()}, nodes use a dual-encoding approach: the interior fill
shows the derivation type (R, Python, etc.) while the border shows
the pipeline group colour.
}
\examples{
\dontrun{
  rxp_visnetwork()
  rxp_visnetwork(colour_by = "type")  # Color by derivation type instead
}
}
\seealso{
Other visualisation functions: 
\code{\link{rxp_ggdag}()}
}
\concept{visualisation functions}
