% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-load.R
\name{load_id}
\alias{load_id}
\alias{load_id.src_tbl}
\alias{load_id.character}
\alias{load_id.itm}
\alias{load_id.fun_itm}
\alias{load_id.default}
\alias{load_ts}
\alias{load_ts.src_tbl}
\alias{load_ts.character}
\alias{load_ts.itm}
\alias{load_ts.fun_itm}
\alias{load_ts.default}
\alias{load_win}
\alias{load_win.src_tbl}
\alias{load_win.character}
\alias{load_win.itm}
\alias{load_win.fun_itm}
\alias{load_win.default}
\title{Load data as \code{id_tbl} or \code{ts_tbl} objects}
\usage{
load_id(x, ...)

\method{load_id}{src_tbl}(
  x,
  rows,
  cols = colnames(x),
  id_var = id_vars(x),
  interval = hours(1L),
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_id}{character}(x, src, ...)

\method{load_id}{itm}(
  x,
  cols = colnames(x),
  id_var = id_vars(x),
  interval = hours(1L),
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_id}{fun_itm}(x, ...)

\method{load_id}{default}(x, ...)

load_ts(x, ...)

\method{load_ts}{src_tbl}(
  x,
  rows,
  cols = colnames(x),
  id_var = id_vars(x),
  index_var = ricu::index_var(x),
  interval = hours(1L),
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_ts}{character}(x, src, ...)

\method{load_ts}{itm}(
  x,
  cols = colnames(x),
  id_var = id_vars(x),
  index_var = ricu::index_var(x),
  interval = hours(1L),
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_ts}{fun_itm}(x, ...)

\method{load_ts}{default}(x, ...)

load_win(x, ...)

\method{load_win}{src_tbl}(
  x,
  rows,
  cols = colnames(x),
  id_var = id_vars(x),
  index_var = ricu::index_var(x),
  interval = hours(1L),
  dur_var = ricu::dur_var(x),
  dur_is_end = TRUE,
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_win}{character}(x, src, ...)

\method{load_win}{itm}(
  x,
  cols = colnames(x),
  id_var = id_vars(x),
  index_var = ricu::index_var(x),
  interval = hours(1L),
  dur_var = ricu::dur_var(x),
  dur_is_end = TRUE,
  time_vars = ricu::time_vars(x),
  ...
)

\method{load_win}{fun_itm}(x, ...)

\method{load_win}{default}(x, ...)
}
\arguments{
\item{x}{Object for which to load data}

\item{...}{Generic consistency}

\item{rows}{Expression used for row subsetting (NSE)}

\item{cols}{Character vector of column names}

\item{id_var}{The column defining the id of \code{ts_tbl} and \code{id_tbl} objects}

\item{interval}{The time interval used to discretize time stamps with,
specified as \code{\link[base:difftime]{base::difftime()}} object}

\item{time_vars}{Character vector enumerating the columns to be treated as
timestamps and thus returned as \code{\link[base:difftime]{base::difftime()}} vectors}

\item{src}{Passed to \code{\link[=as_src_tbl]{as_src_tbl()}} in order to determine the data source}

\item{index_var}{The column defining the index of \code{ts_tbl} objects}

\item{dur_var}{The column used for determining durations}

\item{dur_is_end}{Logical flag indicating whether to use durations as-is or
to calculated them by subtracting the \code{index_var} column}
}
\value{
An \code{id_tbl} or a \code{ts_tbl} object.
}
\description{
Building on functionality provided by \code{\link[=load_src]{load_src()}} and \code{\link[=load_difftime]{load_difftime()}},
\code{load_id()} and \code{load_ts()} load data from disk as \code{id_tbl} and \code{ts_tbl}
objects respectively. Over \code{load_difftime()} both \code{load_id()} and
\code{load_ts()} provide a way to specify \code{\link[=meta_vars]{meta_vars()}} (as \code{id_var} and
\code{index_var} arguments), as well as an interval size (as \code{interval}
argument) for time series data.
}
\details{
While for \code{\link[=load_difftime]{load_difftime()}} the ID variable can be suggested, the function
only returns a best effort at fulfilling this request. In some cases, where
the data does not allow for the desired ID type, data is returned using the
ID system (among all available ones for the given table) with highest
cardinality. Both \code{load_id()} and \code{load_ts()} are guaranteed to return an
object with \code{\link[=id_vars]{id_vars()}} set as requested by the \code{id_var} argument.
Internally, the change of ID system is performed by \code{\link[=change_id]{change_id()}}.

Additionally, while times returned by \code{\link[=load_difftime]{load_difftime()}} are in 1 minute
resolution, the time series step size can be specified by the \code{interval}
argument when calling \code{load_id()} or \code{load_ts()}. This rounding and
potential change of time unit is performed by \code{\link[=change_interval]{change_interval()}} on all
columns specified by the \code{time_vars} argument. All time stamps are relative
to the origin provided by the ID system. This means that for an \code{id_var}
corresponding to hospital IDs, times are relative to hospital admission.

When \code{load_id()} (or \code{load_ts()}) is called on \code{\link[=new_itm]{itm}} objects
instead of \code{\link[=new_src_tbl]{src_tbl}} (or objects that can be coerced to
\code{src_tbl}), The row-subsetting is performed according the the specification
as provided by the \code{itm} object. Furthermore, at default settings, columns
are returned as required by the \code{itm} object and \code{id_var} (as well as
\code{index_var}) are set accordingly if specified by the \code{itm} or set to
default values for the given \code{src_tbl} object if not explicitly specified.
}
\examples{
if (require(mimic.demo)) {
load_id("admissions", "mimic_demo", cols = "admission_type")

dat <- load_ts(mimic_demo$labevents, itemid \%in\% c(50809L, 50931L),
               cols = c("itemid", "valuenum"))

glu <- new_itm(src = "mimic_demo", table = "labevents",
               sub_var = "itemid", ids = c(50809L, 50931L))

identical(load_ts(glu), dat)
}

}
