% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_from_density.R
\name{simulate_from_density}
\alias{simulate_from_density}
\title{Simulate from density}
\usage{
simulate_from_density(vec, N = 1e+05)
}
\arguments{
\item{vec}{Numeric vector}

\item{N}{Integer, number of simulated instances}
}
\value{
A numeric vector of length \code{N} with values simulated from the
kernel density estimate of \code{vec}.
}
\description{
Compared with bootstrapping, the results do not reveal input values, and the
empirical distribution can be smoother. The function assumes that the distribution
can be aproximated using a gaussian kernel.
}
\examples{
my_vec <- c(23, 27, 26, 24, 25)
simulate_from_density(my_vec, 10)
}
\author{
Iakov Davydov
}
