% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GctMatrix.R
\name{gctDesc}
\alias{gctDesc}
\title{Retrieve feature (row) descriptions from a GctMatrix S3-object}
\usage{
gctDesc(gctMatrix, index)
}
\arguments{
\item{gctMatrix}{A GctMatrix object}

\item{index}{Logical or integer index}
}
\value{
Character vector, feature descriptions
}
\description{
Retrieve feature (row) descriptions from a GctMatrix S3-object
}
\examples{
m1 <- matrix(1:6, nrow=3, dimnames=list(sprintf("G\%d", 1:3), sprintf("S\%d", 1:2)))
gm1 <- GctMatrix(m1, desc=sprintf("Gene\%d", 1:3))
gctDesc(gm1)
gctDesc(gm1, 1:2)
}
